/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.AbstractKMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.KMeansModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import java.util.ArrayList;
import java.util.List;

@Title(value="K-Means")
@Description(value="Finds a least-squares partitioning into k clusters.")
@Reference(authors="J. MacQueen", title="Some Methods for Classification and Analysis of Multivariate Observations", booktitle="5th Berkeley Symp. Math. Statist. Prob., Vol. 1, 1967, pp 281-297", url="http://projecteuclid.org/euclid.bsmsp/1200512992")
public class KMeansMacQueen<V extends NumberVector>
extends AbstractKMeans<V, KMeansModel> {
    private static final Logging LOG = Logging.getLogger(KMeansMacQueen.class);
    private static final String KEY = KMeansMacQueen.class.getName();

    public KMeansMacQueen(NumberVectorDistanceFunction<? super V> numberVectorDistanceFunction, int n, int n2, KMeansInitialization<? super V> kMeansInitialization) {
        super(numberVectorDistanceFunction, n, n2, kMeansInitialization);
    }

    @Override
    public Clustering<KMeansModel> run(Database database, Relation<V> relation) {
        int n;
        if (relation.size() <= 0) {
            return new Clustering<KMeansModel>("k-Means Clustering", "kmeans-clustering");
        }
        if (LOG.isStatistics()) {
            LOG.statistics(new StringStatistic(KEY + ".initialization", this.initializer.toString()));
        }
        List<Vector> list = this.initializer.chooseInitialMeans(database, relation, this.k, this.getDistanceFunction(), Vector.FACTORY);
        ArrayList<ModifiableDBIDs> arrayList = new ArrayList<ModifiableDBIDs>();
        for (int i = 0; i < this.k; ++i) {
            arrayList.add(DBIDUtil.newHashSet((int)((double)relation.size() * 2.0 / (double)this.k)));
        }
        WritableIntegerDataStore writableIntegerDataStore = DataStoreUtil.makeIntegerStorage(relation.getDBIDs(), 3, -1);
        double[] dArray = new double[this.k];
        IndefiniteProgress indefiniteProgress = LOG.isVerbose() ? new IndefiniteProgress("K-Means iteration", LOG) : null;
        DoubleStatistic doubleStatistic = LOG.isStatistics() ? new DoubleStatistic(this.getClass().getName() + ".variance-sum") : null;
        for (n = 0; this.maxiter <= 0 || n < this.maxiter; ++n) {
            LOG.incrementProcessed(indefiniteProgress);
            boolean bl = this.macQueenIterate(relation, list, arrayList, writableIntegerDataStore, dArray);
            this.logVarstat(doubleStatistic, dArray);
            if (!bl) break;
        }
        LOG.setCompleted(indefiniteProgress);
        if (LOG.isStatistics()) {
            LOG.statistics(new LongStatistic(KEY + ".iterations", n));
        }
        Clustering<KMeansModel> clustering = new Clustering<KMeansModel>("k-Means Clustering", "kmeans-clustering");
        for (int i = 0; i < arrayList.size(); ++i) {
            DBIDs dBIDs = (DBIDs)arrayList.get(i);
            if (dBIDs.size() == 0) continue;
            KMeansModel kMeansModel = new KMeansModel(list.get(i), dArray[i]);
            clustering.addToplevelCluster(new Cluster<KMeansModel>(dBIDs, kMeansModel));
        }
        return clustering;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractKMeans.Parameterizer<V> {
        @Override
        protected Logging getLogger() {
            return LOG;
        }

        @Override
        protected KMeansMacQueen<V> makeInstance() {
            return new KMeansMacQueen(this.distanceFunction, this.k, this.maxiter, this.initializer);
        }
    }
}

