/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.onedimensional;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.data.model.ClusterModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.EpanechnikovKernelDensityFunction;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.KernelDensityFunction;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class KNNKernelDensityMinimaClustering<V extends NumberVector>
extends AbstractAlgorithm<Clustering<ClusterModel>>
implements ClusteringAlgorithm<Clustering<ClusterModel>> {
    private static final Logging LOG = Logging.getLogger(KNNKernelDensityMinimaClustering.class);
    protected int dim;
    protected KernelDensityFunction kernel;
    protected Mode mode;
    protected int k;
    protected int minwindow;

    public KNNKernelDensityMinimaClustering(int n, KernelDensityFunction kernelDensityFunction, Mode mode, int n2, int n3) {
        this.dim = n;
        this.kernel = kernelDensityFunction;
        this.mode = mode;
        this.k = n2;
        this.minwindow = n3;
    }

    public Clustering<ClusterModel> run(Relation<V> relation) {
        int n;
        int n2;
        int n3;
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(relation.getDBIDs());
        int n4 = arrayModifiableDBIDs.size();
        arrayModifiableDBIDs.sort(new VectorUtil.SortDBIDsBySingleDimension(relation, this.dim));
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(arrayModifiableDBIDs, 3, 0.0);
        DBIDArrayMIter dBIDArrayMIter = arrayModifiableDBIDs.iter();
        DBIDArrayMIter dBIDArrayMIter2 = arrayModifiableDBIDs.iter();
        StepProgress stepProgress = LOG.isVerbose() ? new StepProgress("Clustering steps", 2) : null;
        LOG.beginStep(stepProgress, 1, "Kernel density estimation.");
        Object object = new double[2 * this.k];
        dBIDArrayMIter.seek(0);
        for (int i = 0; i < n4; ++i) {
            int n5;
            double d = ((NumberVector)relation.get(dBIDArrayMIter)).doubleValue(this.dim);
            n3 = Math.max(i - this.k, 0);
            n2 = i - n3;
            n = Math.min(i + this.k, n4 - 1);
            int n6 = n - i;
            dBIDArrayMIter2.seek(n3);
            for (n5 = 0; n5 < n2; ++n5) {
                object[n5] = d - ((NumberVector)relation.get(dBIDArrayMIter2)).doubleValue(this.dim);
                dBIDArrayMIter2.advance();
            }
            assert (dBIDArrayMIter2.getOffset() == i);
            dBIDArrayMIter2.advance();
            for (n5 = 0; n5 < n6; ++n5) {
                object[n2 + n5] = ((NumberVector)relation.get(dBIDArrayMIter2)).doubleValue(this.dim) - d;
                dBIDArrayMIter2.advance();
            }
            assert (n2 + n6 >= this.k);
            double d2 = QuickSelect.quickSelect((double[])object, 0, n2 + n6, this.k);
            switch (this.mode) {
                case BALLOON: {
                    double d3 = 0.0;
                    if (d2 > 0.0) {
                        for (int j = 0; j < n2 + n6; ++j) {
                            d3 += this.kernel.density((double)(object[j] / d2));
                        }
                    } else {
                        d3 = Double.POSITIVE_INFINITY;
                    }
                    assert (dBIDArrayMIter.getOffset() == i);
                    writableDoubleDataStore.putDouble(dBIDArrayMIter, d3);
                    break;
                }
                case SAMPLE: {
                    double d4;
                    if (d2 > 0.0) {
                        int n7;
                        dBIDArrayMIter2.seek(n3);
                        for (n7 = 0; n7 < n2; ++n7) {
                            d4 = d - ((NumberVector)relation.get(dBIDArrayMIter2)).doubleValue(this.dim);
                            writableDoubleDataStore.putDouble(dBIDArrayMIter2, writableDoubleDataStore.doubleValue(dBIDArrayMIter2) + this.kernel.density(d4 / d2));
                            dBIDArrayMIter2.advance();
                        }
                        assert (dBIDArrayMIter2.getOffset() == i);
                        dBIDArrayMIter2.advance();
                        for (n7 = 0; n7 < n6; ++n7) {
                            d4 = ((NumberVector)relation.get(dBIDArrayMIter2)).doubleValue(this.dim) - d;
                            writableDoubleDataStore.putDouble(dBIDArrayMIter2, writableDoubleDataStore.doubleValue(dBIDArrayMIter2) + this.kernel.density(d4 / d2));
                            dBIDArrayMIter2.advance();
                        }
                    } else {
                        int n8;
                        dBIDArrayMIter2.seek(n3);
                        for (n8 = 0; n8 < n2; ++n8) {
                            d4 = d - ((NumberVector)relation.get(dBIDArrayMIter2)).doubleValue(this.dim);
                            if (!(d4 > 0.0)) {
                                writableDoubleDataStore.putDouble(dBIDArrayMIter2, Double.POSITIVE_INFINITY);
                            }
                            dBIDArrayMIter2.advance();
                        }
                        assert (dBIDArrayMIter2.getOffset() == i);
                        dBIDArrayMIter2.advance();
                        for (n8 = 0; n8 < n6; ++n8) {
                            d4 = ((NumberVector)relation.get(dBIDArrayMIter2)).doubleValue(this.dim) - d;
                            if (!(d4 > 0.0)) {
                                writableDoubleDataStore.putDouble(dBIDArrayMIter2, Double.POSITIVE_INFINITY);
                            }
                            dBIDArrayMIter2.advance();
                        }
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown mode specified.");
                }
            }
            dBIDArrayMIter.advance();
        }
        LOG.beginStep(stepProgress, 2, "Local minima detection.");
        object = new Clustering("onedimensional-kde-clustering", "One-Dimensional clustering using kernel density estimation.");
        double[] dArray = new double[2 * this.minwindow + 1];
        int n9 = 0;
        int n10 = this.minwindow + 1 >> 1;
        dBIDArrayMIter.seek(0);
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = n3 % dArray.length;
            n = (n3 - this.minwindow - 1) % dArray.length;
            dArray[n2] = writableDoubleDataStore.doubleValue(dBIDArrayMIter);
            if (n3 > dArray.length) {
                int n11;
                double d = Double.POSITIVE_INFINITY;
                for (n11 = 0; n11 < dArray.length; ++n11) {
                    if (n11 == n || !(dArray[n11] < d)) continue;
                    d = dArray[n11];
                }
                if (dArray[n] < d) {
                    n11 = n3 - this.minwindow + 1;
                    dBIDArrayMIter2.seek(n11);
                    double d5 = ((NumberVector)relation.get(dBIDArrayMIter2)).doubleValue(this.dim);
                    dBIDArrayMIter2.seek(n11 - n10);
                    double d6 = ((NumberVector)relation.get(dBIDArrayMIter2)).doubleValue(this.dim) - d5;
                    dBIDArrayMIter2.seek(n11 + n10);
                    double d7 = d5 - ((NumberVector)relation.get(dBIDArrayMIter2)).doubleValue(this.dim);
                    if (d6 < d7) {
                        ++n11;
                    }
                    dBIDArrayMIter2.seek(n9);
                    ArrayModifiableDBIDs arrayModifiableDBIDs2 = DBIDUtil.newArray(n11 - n9);
                    for (int i = 0; i < n11 - n9; ++i) {
                        arrayModifiableDBIDs2.add(dBIDArrayMIter2);
                        dBIDArrayMIter2.advance();
                    }
                    ((Clustering)object).addToplevelCluster(new Cluster<ClusterModel>((DBIDs)arrayModifiableDBIDs2, ClusterModel.CLUSTER));
                    n9 = n11;
                }
            }
            dBIDArrayMIter.advance();
        }
        n3 = n4;
        dBIDArrayMIter2.seek(n9);
        ArrayModifiableDBIDs arrayModifiableDBIDs3 = DBIDUtil.newArray(n3 - n9);
        for (n = 0; n < n3 - n9; ++n) {
            arrayModifiableDBIDs3.add(dBIDArrayMIter2);
            dBIDArrayMIter2.advance();
        }
        ((Clustering)object).addToplevelCluster(new Cluster<ClusterModel>((DBIDs)arrayModifiableDBIDs3, ClusterModel.CLUSTER));
        LOG.ensureCompleted(stepProgress);
        return object;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(VectorFieldTypeInformation.typeRequest(NumberVector.class, this.dim + 1, Integer.MAX_VALUE));
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID DIM_ID = new OptionID("kernelcluster.dim", "Dimension to use for clustering. For one-dimensional data, use 0.");
        public static final OptionID KERNEL_ID = new OptionID("kernelcluster.kernel", "Kernel function for density estimation.");
        public static final OptionID MODE_ID = new OptionID("kernelcluster.mode", "Kernel density estimation mode (baloon estimator vs. sample point estimator).");
        public static final OptionID K_ID = new OptionID("kernelcluster.knn", "Number of nearest neighbors to use for bandwidth estimation.");
        public static final OptionID WINDOW_ID = new OptionID("kernelcluster.window", "Half width of sliding window to find local minima.");
        protected int dim;
        protected KernelDensityFunction kernel;
        protected Mode mode;
        protected int k;
        protected int minwindow;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            EnumParameter<Mode> enumParameter;
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(DIM_ID, 0);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (parameterization.grab(intParameter)) {
                this.dim = intParameter.intValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(KERNEL_ID, (Class<?>)KernelDensityFunction.class, EpanechnikovKernelDensityFunction.class))) {
                this.kernel = (KernelDensityFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(enumParameter = new EnumParameter<Mode>(MODE_ID, Mode.class, Mode.BALLOON))) {
                this.mode = (Mode)((Object)enumParameter.getValue());
            }
            IntParameter intParameter2 = new IntParameter(K_ID);
            intParameter2.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter2)) {
                this.k = intParameter2.intValue();
            }
            IntParameter intParameter3 = new IntParameter(WINDOW_ID);
            intParameter3.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter3)) {
                this.minwindow = intParameter3.intValue();
            }
        }

        @Override
        protected KNNKernelDensityMinimaClustering<V> makeInstance() {
            return new KNNKernelDensityMinimaClustering(this.dim, this.kernel, this.mode, this.k, this.minwindow);
        }
    }

    public static enum Mode {
        BALLOON,
        SAMPLE;

    }
}

