/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.uncertain;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.DistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMedoidsEM;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.uncertain.UncertainObject;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ProxyDatabase;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDFactory;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.cluster.ClusteringAdjustedRandIndexSimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.cluster.ClusteringDistanceSimilarityFunction;
import de.lmu.ifi.dbs.elki.index.distancematrix.PrecomputedDistanceMatrix;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.result.BasicResult;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ChainedParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleObjPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

@Reference(authors="Andreas Z\u00fcfle, Tobias Emrich, Klaus Arthur Schmid, Nikos Mamoulis, Arthur Zimek, Mathias Renz", title="Representative clustering of uncertain data", booktitle="Proc. 20th ACM SIGKDD International Conference on Knowledge Discovery and Data Mining", url="http://dx.doi.org/10.1145/2623330.2623725")
public class RepresentativeUncertainClustering
extends AbstractAlgorithm<Clustering<Model>>
implements ClusteringAlgorithm<Clustering<Model>> {
    private static final Logging LOG = Logging.getLogger(RepresentativeUncertainClustering.class);
    protected ClusteringDistanceSimilarityFunction distance;
    protected ClusteringAlgorithm<?> metaAlgorithm;
    protected ClusteringAlgorithm<?> samplesAlgorithm;
    protected int numsamples;
    protected RandomFactory random;
    protected double alpha;
    protected boolean keep;

    public RepresentativeUncertainClustering(ClusteringDistanceSimilarityFunction clusteringDistanceSimilarityFunction, ClusteringAlgorithm<?> clusteringAlgorithm, ClusteringAlgorithm<?> clusteringAlgorithm2, int n, RandomFactory randomFactory, double d, boolean bl) {
        this.samplesAlgorithm = clusteringAlgorithm2;
        this.numsamples = n;
        this.metaAlgorithm = clusteringAlgorithm;
        this.distance = clusteringDistanceSimilarityFunction;
        this.random = randomFactory;
        this.alpha = d;
        this.keep = bl;
    }

    public Clustering<?> run(Database database, Relation<? extends UncertainObject> relation) {
        MaterializedRelation<Object> materializedRelation;
        WritableDataStore<Object> writableDataStore;
        ResultHierarchy resultHierarchy = database.getHierarchy();
        ArrayList arrayList = new ArrayList();
        int n = RelationUtil.dimensionality(relation);
        DBIDs dBIDs = relation.getDBIDs();
        BasicResult basicResult = new BasicResult("Samples", "samples");
        Random random = this.random.getSingleThreadedRandom();
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Clustering samples", this.numsamples, LOG) : null;
        for (int i = 0; i < this.numsamples; ++i) {
            writableDataStore = DataStoreUtil.makeStorage(dBIDs, 30, DoubleVector.class);
            materializedRelation = dBIDs.iter();
            while (materializedRelation.valid()) {
                writableDataStore.put((DBIDRef)((Object)materializedRelation), relation.get((DBIDRef)((Object)materializedRelation)).drawSample(random));
                materializedRelation.advance();
            }
            arrayList.add(this.runClusteringAlgorithm(resultHierarchy, basicResult, dBIDs, writableDataStore, n, "Sample " + i));
            LOG.incrementProcessed(finiteProgress);
        }
        LOG.ensureCompleted(finiteProgress);
        DBIDRange dBIDRange = DBIDFactory.FACTORY.generateStaticDBIDRange(arrayList.size());
        writableDataStore = DataStoreUtil.makeStorage(dBIDRange, 30, Clustering.class);
        materializedRelation = arrayList.iterator();
        Object object = dBIDRange.iter();
        while (object.valid()) {
            writableDataStore.put((DBIDRef)object, materializedRelation.next());
            object.advance();
        }
        assert (dBIDRange.size() == arrayList.size());
        materializedRelation = new MaterializedRelation<Object>(TypeUtil.CLUSTERING, dBIDRange, "Clusterings", writableDataStore);
        object = new PrecomputedDistanceMatrix<Object>(materializedRelation, this.distance);
        ((PrecomputedDistanceMatrix)object).initialize();
        ProxyDatabase proxyDatabase = new ProxyDatabase((DBIDs)dBIDRange, materializedRelation);
        proxyDatabase.getHierarchy().add(materializedRelation, (Result)object);
        Object obj = this.metaAlgorithm.run(proxyDatabase);
        proxyDatabase.getHierarchy().remove(proxyDatabase, (Result)obj);
        BasicResult basicResult2 = new BasicResult("Representants", "representative");
        resultHierarchy.add(relation, basicResult2);
        DistanceQuery<DBIDIter> distanceQuery = ((PrecomputedDistanceMatrix)object).getDistanceQuery(this.distance, new Object[0]);
        List list = ((Clustering)obj).getAllClusters();
        ArrayList<DoubleObjPair<Clustering>> arrayList2 = new ArrayList<DoubleObjPair<Clustering>>(list.size());
        for (Cluster object2 : list) {
            double iter = Double.POSITIVE_INFINITY;
            Clustering clustering = null;
            DBIDIter dBIDIter = object2.getIDs().iter();
            while (dBIDIter.valid()) {
                double d = 0.0;
                Clustering clustering2 = (Clustering)materializedRelation.get(dBIDIter);
                DBIDIter dBIDIter2 = object2.getIDs().iter();
                while (dBIDIter2.valid()) {
                    if (!DBIDUtil.equal(dBIDIter, dBIDIter2)) {
                        double d2 = distanceQuery.distance((DBIDIter)((Object)clustering2), dBIDIter2);
                        d = d2 > d ? d2 : d;
                    }
                    dBIDIter2.advance();
                }
                if (d < iter) {
                    iter = d;
                    clustering = clustering2;
                }
                dBIDIter.advance();
            }
            if (clustering == null) continue;
            double d = 0.0;
            DBIDIter dBIDIter3 = materializedRelation.iterDBIDs();
            while (dBIDIter3.valid()) {
                double d3 = distanceQuery.distance((DBIDIter)((Object)clustering), dBIDIter3);
                d = d3 > d ? d3 : d;
                dBIDIter3.advance();
            }
            double d4 = this.computeConfidence(object2.size(), materializedRelation.size());
            resultHierarchy.add(clustering, new RepresentativenessEvaluation(d, iter, d4));
            arrayList2.add(new DoubleObjPair<Clustering>(d4, clustering));
        }
        Collections.sort(arrayList2, Collections.reverseOrder());
        for (DoubleObjPair doubleObjPair : arrayList2) {
            Hierarchy.Iter iter = resultHierarchy.iterParents(doubleObjPair.second);
            while (iter.valid()) {
                if (iter.get() instanceof Relation) {
                    resultHierarchy.add(basicResult2, (Result)iter.get());
                }
                iter.advance();
            }
        }
        if (this.keep) {
            resultHierarchy.add(relation, basicResult);
        } else {
            resultHierarchy.removeSubtree(basicResult);
        }
        return obj;
    }

    private double computeConfidence(int n, int n2) {
        double d = NormalDistribution.standardNormalQuantile(this.alpha);
        double d2 = (double)n / (double)n2;
        return Math.max(0.0, d2 - d * Math.sqrt(d2 * (1.0 - d2) / (double)n2));
    }

    protected Clustering<?> runClusteringAlgorithm(ResultHierarchy resultHierarchy, Result result, DBIDs dBIDs, DataStore<DoubleVector> dataStore, int n, String string) {
        VectorFieldTypeInformation<DoubleVector> vectorFieldTypeInformation = new VectorFieldTypeInformation<DoubleVector>(DoubleVector.FACTORY, n);
        MaterializedRelation<DoubleVector> materializedRelation = new MaterializedRelation<DoubleVector>(vectorFieldTypeInformation, dBIDs, string, dataStore);
        ProxyDatabase proxyDatabase = new ProxyDatabase(dBIDs, materializedRelation);
        Object obj = this.samplesAlgorithm.run(proxyDatabase);
        proxyDatabase.getHierarchy().remove(materializedRelation);
        proxyDatabase.getHierarchy().remove(obj);
        resultHierarchy.add(result, materializedRelation);
        resultHierarchy.add(materializedRelation, (Result)obj);
        return obj;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.UNCERTAIN_OBJECT_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final int DEFAULT_ENSEMBLE_DEPTH = 10;
        public static final OptionID CLUSTERDISTANCE_ID = new OptionID("pwc.distance", "Distance measure of clusterings.");
        public static final OptionID META_ALGORITHM_ID = new OptionID("pwc.metaclustering", "Algorithm used to aggregate clustering results. Must be a distance-based clustering algorithm.");
        public static final OptionID ALGORITHM_ID = new OptionID("pwc.clustering", "Clustering algorithm used on the samples.");
        public static final OptionID SAMPLES_ID = new OptionID("pwc.samples", "Number of clusterings to produce on samples.");
        public static final OptionID KEEP_SAMPLES_ID = new OptionID("pwc.samples.keep", "Retain all sampled relations, not only the representative results.");
        public static final OptionID RANDOM_ID = new OptionID("pwc.random", "Random generator used for sampling.");
        public static final OptionID ALPHA_ID = new OptionID("pwc.alpha", "Alpha threshold for estimating the confidence probability.");
        protected ClusteringDistanceSimilarityFunction distance;
        protected ClusteringAlgorithm<?> metaAlgorithm;
        protected ClusteringAlgorithm<?> samplesAlgorithm;
        protected int numsamples;
        protected RandomFactory random;
        protected double alpha;
        protected boolean keep;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            RandomParameter randomParameter;
            Flag flag;
            IntParameter intParameter;
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            this.distance = ClusteringAdjustedRandIndexSimilarityFunction.STATIC;
            ObjectParameter objectParameter2 = new ObjectParameter(CLUSTERDISTANCE_ID, (Class<?>)ClusteringDistanceSimilarityFunction.class, ClusteringAdjustedRandIndexSimilarityFunction.class);
            if (parameterization.grab(objectParameter2)) {
                this.distance = (ClusteringDistanceSimilarityFunction)objectParameter2.instantiateClass(parameterization);
            }
            ListParameterization listParameterization = new ListParameterization();
            listParameterization.addParameter(DistanceBasedAlgorithm.DISTANCE_FUNCTION_ID, this.distance);
            ChainedParameterization chainedParameterization = new ChainedParameterization(listParameterization, parameterization);
            chainedParameterization.errorsTo(parameterization);
            ObjectParameter objectParameter3 = new ObjectParameter(META_ALGORITHM_ID, (Class<?>)ClusteringAlgorithm.class, KMedoidsEM.class);
            if (chainedParameterization.grab(objectParameter3)) {
                this.metaAlgorithm = (ClusteringAlgorithm)objectParameter3.instantiateClass(chainedParameterization);
                if (this.metaAlgorithm != null && this.metaAlgorithm.getInputTypeRestriction().length > 0 && !this.metaAlgorithm.getInputTypeRestriction()[0].isAssignableFromType(TypeUtil.CLUSTERING)) {
                    parameterization.reportError(new WrongParameterValueException(objectParameter3, objectParameter3.getValueAsString(), "The meta clustering algorithm (as configured) does not accept clustering results."));
                }
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(ALGORITHM_ID, ClusteringAlgorithm.class))) {
                this.samplesAlgorithm = (ClusteringAlgorithm)objectParameter.instantiateClass(parameterization);
                if (this.samplesAlgorithm != null && this.samplesAlgorithm.getInputTypeRestriction().length > 0 && !this.samplesAlgorithm.getInputTypeRestriction()[0].isAssignableFromType(TypeUtil.NUMBER_VECTOR_FIELD)) {
                    parameterization.reportError(new WrongParameterValueException(objectParameter, objectParameter.getValueAsString(), "The inner clustering algorithm (as configured) does not accept numerical vectors: " + this.samplesAlgorithm.getInputTypeRestriction()[0]));
                }
            }
            if (parameterization.grab(intParameter = new IntParameter(SAMPLES_ID, 10))) {
                this.numsamples = (Integer)intParameter.getValue();
            }
            if (parameterization.grab(flag = new Flag(KEEP_SAMPLES_ID))) {
                this.keep = flag.isTrue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(RANDOM_ID))) {
                this.random = (RandomFactory)randomParameter.getValue();
            }
            if (parameterization.grab(doubleParameter = (DoubleParameter)((DoubleParameter)new DoubleParameter(ALPHA_ID, 0.95).addConstraint(CommonConstraints.GREATER_THAN_ONE_DOUBLE)).addConstraint(CommonConstraints.LESS_THAN_ONE_DOUBLE))) {
                this.alpha = doubleParameter.doubleValue();
            }
        }

        @Override
        protected RepresentativeUncertainClustering makeInstance() {
            return new RepresentativeUncertainClustering(this.distance, this.metaAlgorithm, this.samplesAlgorithm, this.numsamples, this.random, this.alpha, this.keep);
        }
    }

    public static class RepresentativenessEvaluation
    extends EvaluationResult {
        public RepresentativenessEvaluation(double d, double d2, double d3) {
            super("Possible-Worlds Evaluation", "representativeness");
            EvaluationResult.MeasurementGroup measurementGroup = this.newGroup("Representativeness");
            measurementGroup.addMeasure("Confidence", d3, 0.0, 1.0, false);
            measurementGroup.addMeasure("Global Tau", d, 0.0, 1.0, true);
            measurementGroup.addMeasure("Cluster Tau", d2, 0.0, 1.0, true);
        }

        @Override
        public boolean visualizeSingleton() {
            return true;
        }
    }
}

