/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.CombinedTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.PreprocessorKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.QuotientOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;

@Title(value="LOF: Local Outlier Factor")
@Description(value="Algorithm to compute density-based local outlier factors in a database based on the neighborhood size parameter 'k'")
@Reference(authors="M. M. Breunig, H.-P. Kriegel, R. Ng, J. Sander", title="LOF: Identifying Density-Based Local Outliers", booktitle="Proc. 2nd ACM SIGMOD Int. Conf. on Management of Data (SIGMOD '00), Dallas, TX, 2000", url="http://dx.doi.org/10.1145/342009.335388")
public class FlexibleLOF<O>
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(FlexibleLOF.class);
    protected int krefer = 2;
    protected int kreach = 2;
    protected DistanceFunction<? super O> referenceDistanceFunction;
    protected DistanceFunction<? super O> reachabilityDistanceFunction;

    public FlexibleLOF(int n, int n2, DistanceFunction<? super O> distanceFunction, DistanceFunction<? super O> distanceFunction2) {
        this.krefer = n + 1;
        this.kreach = n2 + 1;
        this.referenceDistanceFunction = distanceFunction;
        this.reachabilityDistanceFunction = distanceFunction2;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        StepProgress stepProgress = LOG.isVerbose() ? new StepProgress("LOF", 3) : null;
        Pair<KNNQuery<O>, KNNQuery<O>> pair = this.getKNNQueries(database, relation, stepProgress);
        KNNQuery<O> kNNQuery = pair.getFirst();
        KNNQuery<O> kNNQuery2 = pair.getSecond();
        return this.doRunInTime(relation.getDBIDs(), kNNQuery, kNNQuery2, stepProgress).getResult();
    }

    private Pair<KNNQuery<O>, KNNQuery<O>> getKNNQueries(Database database, Relation<O> relation, StepProgress stepProgress) {
        DistanceQuery<? super O> distanceQuery = database.getDistanceQuery(relation, this.reachabilityDistanceFunction, "heavy");
        KNNQuery<? super O> kNNQuery = database.getKNNQuery(distanceQuery, this.kreach, "heavy", "optimized", "no-cache");
        if (!(kNNQuery instanceof PreprocessorKNNQuery)) {
            if (stepProgress != null) {
                if (this.referenceDistanceFunction.equals(this.reachabilityDistanceFunction)) {
                    stepProgress.beginStep(1, "Materializing neighborhoods w.r.t. reference neighborhood distance function.", LOG);
                } else {
                    stepProgress.beginStep(1, "Not materializing neighborhoods w.r.t. reference neighborhood distance function, but materializing neighborhoods w.r.t. reachability distance function.", LOG);
                }
            }
            int n = this.referenceDistanceFunction.equals(this.reachabilityDistanceFunction) ? Math.max(this.kreach, this.krefer) : this.kreach;
            kNNQuery = DatabaseUtil.precomputedKNNQuery(database, relation, this.reachabilityDistanceFunction, n);
        }
        KNNQuery<? super O> kNNQuery2 = this.referenceDistanceFunction == this.reachabilityDistanceFunction || this.referenceDistanceFunction.equals(this.reachabilityDistanceFunction) ? kNNQuery : QueryUtil.getKNNQuery(relation, this.referenceDistanceFunction, this.krefer);
        return new Pair<KNNQuery<O>, KNNQuery<O>>(kNNQuery2, kNNQuery);
    }

    protected LOFResult<O> doRunInTime(DBIDs dBIDs, KNNQuery<O> kNNQuery, KNNQuery<O> kNNQuery2, StepProgress stepProgress) {
        if (kNNQuery == null) {
            throw new AbortException("No kNN queries supported by database for reference neighborhood distance function.");
        }
        if (kNNQuery2 == null) {
            throw new AbortException("No kNN queries supported by database for reachability distance function.");
        }
        LOG.beginStep(stepProgress, 2, "Computing LRDs.");
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 3);
        this.computeLRDs(kNNQuery2, dBIDs, writableDoubleDataStore);
        LOG.beginStep(stepProgress, 3, "Computing LOFs.");
        WritableDoubleDataStore writableDoubleDataStore2 = DataStoreUtil.makeDoubleStorage(dBIDs, 4);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        this.computeLOFs(kNNQuery, dBIDs, writableDoubleDataStore, writableDoubleDataStore2, doubleMinMax);
        LOG.setCompleted(stepProgress);
        MaterializedDoubleRelation materializedDoubleRelation = new MaterializedDoubleRelation("Local Outlier Factor", "lof-outlier", writableDoubleDataStore2, dBIDs);
        QuotientOutlierScoreMeta quotientOutlierScoreMeta = new QuotientOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        OutlierResult outlierResult = new OutlierResult(quotientOutlierScoreMeta, materializedDoubleRelation);
        return new LOFResult<O>(outlierResult, kNNQuery, kNNQuery2, writableDoubleDataStore, writableDoubleDataStore2);
    }

    protected void computeLRDs(KNNQuery<O> kNNQuery, DBIDs dBIDs, WritableDoubleDataStore writableDoubleDataStore) {
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("LRD", dBIDs.size(), LOG) : null;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, this.kreach);
            double d = 0.0;
            int n = 0;
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            while (doubleDBIDListIter.valid()) {
                if (!DBIDUtil.equal(doubleDBIDListIter, dBIDIter)) {
                    KNNList kNNList2 = kNNQuery.getKNNForDBID(doubleDBIDListIter, this.kreach);
                    d += MathUtil.max(doubleDBIDListIter.doubleValue(), kNNList2.getKNNDistance());
                    ++n;
                }
                doubleDBIDListIter.advance();
            }
            double d2 = d > 0.0 ? (double)n / d : Double.POSITIVE_INFINITY;
            writableDoubleDataStore.putDouble(dBIDIter, d2);
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
    }

    protected void computeLOFs(KNNQuery<O> kNNQuery, DBIDs dBIDs, DoubleDataStore doubleDataStore, WritableDoubleDataStore writableDoubleDataStore, DoubleMinMax doubleMinMax) {
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("LOF_SCORE for objects", dBIDs.size(), LOG) : null;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            double d;
            double d2 = doubleDataStore.doubleValue(dBIDIter);
            KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, this.krefer);
            if (!Double.isInfinite(d2)) {
                double d3 = 0.0;
                int n = 0;
                DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
                while (doubleDBIDListIter.valid()) {
                    if (!DBIDUtil.equal(doubleDBIDListIter, dBIDIter)) {
                        double d4 = doubleDataStore.doubleValue(doubleDBIDListIter);
                        d3 += d4;
                        ++n;
                        if (Double.isInfinite(d4)) break;
                    }
                    doubleDBIDListIter.advance();
                }
                d = d3 / (d2 * (double)n);
            } else {
                d = 1.0;
            }
            writableDoubleDataStore.putDouble(dBIDIter, d);
            doubleMinMax.put(d);
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        TypeInformation typeInformation = this.reachabilityDistanceFunction.equals(this.referenceDistanceFunction) ? this.reachabilityDistanceFunction.getInputTypeRestriction() : new CombinedTypeInformation(this.referenceDistanceFunction.getInputTypeRestriction(), this.reachabilityDistanceFunction.getInputTypeRestriction());
        return TypeUtil.array(typeInformation);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID REACHABILITY_DISTANCE_FUNCTION_ID = new OptionID("lof.reachdistfunction", "Distance function to determine the reachability distance between database objects.");
        public static final OptionID KREF_ID = new OptionID("lof.krefer", "The number of nearest neighbors of an object to be considered for computing its LOF score.");
        public static final OptionID KREACH_ID = new OptionID("lof.kreach", "The number of nearest neighbors of an object to be considered for computing its LOF score.");
        protected int krefer = 2;
        protected int kreach = 2;
        protected DistanceFunction<? super O> neighborhoodDistanceFunction = null;
        protected DistanceFunction<? super O> reachabilityDistanceFunction = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(KREF_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.krefer = intParameter.intValue();
            }
            IntParameter intParameter2 = new IntParameter(KREACH_ID);
            intParameter2.setOptional(true);
            intParameter2.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            this.kreach = parameterization.grab(intParameter2) ? intParameter2.intValue() : this.krefer;
            ObjectParameter objectParameter = new ObjectParameter(REACHABILITY_DISTANCE_FUNCTION_ID, DistanceFunction.class);
            objectParameter.setOptional(true);
            this.reachabilityDistanceFunction = parameterization.grab(objectParameter) ? (DistanceFunction)objectParameter.instantiateClass(parameterization) : this.distanceFunction;
        }

        @Override
        protected FlexibleLOF<O> makeInstance() {
            return new FlexibleLOF<O>(this.kreach, this.krefer, this.distanceFunction, this.reachabilityDistanceFunction);
        }
    }

    public static class LOFResult<O> {
        private OutlierResult result;
        private final KNNQuery<O> kNNRefer;
        private final KNNQuery<O> kNNReach;
        private RKNNQuery<O> rkNNRefer;
        private RKNNQuery<O> rkNNReach;
        private final WritableDoubleDataStore lrds;
        private final WritableDoubleDataStore lofs;

        public LOFResult(OutlierResult outlierResult, KNNQuery<O> kNNQuery, KNNQuery<O> kNNQuery2, WritableDoubleDataStore writableDoubleDataStore, WritableDoubleDataStore writableDoubleDataStore2) {
            this.result = outlierResult;
            this.kNNRefer = kNNQuery;
            this.kNNReach = kNNQuery2;
            this.lrds = writableDoubleDataStore;
            this.lofs = writableDoubleDataStore2;
        }

        public KNNQuery<O> getKNNRefer() {
            return this.kNNRefer;
        }

        public KNNQuery<O> getKNNReach() {
            return this.kNNReach;
        }

        public WritableDoubleDataStore getLrds() {
            return this.lrds;
        }

        public WritableDoubleDataStore getLofs() {
            return this.lofs;
        }

        public OutlierResult getResult() {
            return this.result;
        }

        public void setRkNNRefer(RKNNQuery<O> rKNNQuery) {
            this.rkNNRefer = rKNNQuery;
        }

        public RKNNQuery<O> getRkNNRefer() {
            return this.rkNNRefer;
        }

        public RKNNQuery<O> getRkNNReach() {
            return this.rkNNReach;
        }

        public void setRkNNReach(RKNNQuery<O> rKNNQuery) {
            this.rkNNReach = rKNNQuery;
        }
    }
}

