/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriteable;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterStream;
import java.util.Comparator;

public class Cluster<M extends Model>
implements TextWriteable {
    protected String name = null;
    private DBIDs ids = null;
    private M model = null;
    private boolean noise = false;
    public static Comparator<Cluster<?>> BY_NAME_SORTER = new Comparator<Cluster<?>>(){

        @Override
        public int compare(Cluster<?> cluster, Cluster<?> cluster2) {
            int n;
            if (cluster == cluster2) {
                return 0;
            }
            if (cluster != null && cluster.name != null && cluster2 != null && cluster2.name != null && (n = cluster.name.compareTo(cluster2.getName())) != 0) {
                return n;
            }
            n = cluster.hashCode() - cluster2.hashCode();
            if (n != 0) {
                return n;
            }
            return 0;
        }
    };

    public Cluster(String string, DBIDs dBIDs, boolean bl, M m) {
        this.name = string;
        this.ids = dBIDs;
        this.noise = bl;
        this.model = m;
    }

    public Cluster(String string, DBIDs dBIDs, M m) {
        this(string, dBIDs, false, m);
    }

    public Cluster(DBIDs dBIDs, boolean bl, M m) {
        this(null, dBIDs, bl, m);
    }

    public Cluster(DBIDs dBIDs, M m) {
        this(null, dBIDs, false, m);
    }

    public Cluster(String string, DBIDs dBIDs, boolean bl) {
        this(string, dBIDs, bl, null);
    }

    public Cluster(String string, DBIDs dBIDs) {
        this(string, dBIDs, false, null);
    }

    public Cluster(DBIDs dBIDs, boolean bl) {
        this(null, dBIDs, bl, null);
    }

    public Cluster(DBIDs dBIDs) {
        this(null, dBIDs, false, null);
    }

    public int size() {
        return this.ids.size();
    }

    public String getNameAutomatic() {
        if (this.name != null) {
            return this.name;
        }
        if (this.isNoise()) {
            return "Noise";
        }
        return "Cluster";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public DBIDs getIDs() {
        return this.ids;
    }

    public void setIDs(DBIDs dBIDs) {
        this.ids = dBIDs;
    }

    public M getModel() {
        return this.model;
    }

    public void setModel(M m) {
        this.model = m;
    }

    @Override
    public void writeToText(TextWriterStream textWriterStream, String string) {
        String string2 = this.getNameAutomatic();
        if (string2 != null) {
            textWriterStream.commentPrintLn("Cluster name: " + string2);
        }
        textWriterStream.commentPrintLn("Cluster noise flag: " + this.isNoise());
        textWriterStream.commentPrintLn("Cluster size: " + this.ids.size());
        if (this.getModel() != null && this.getModel() instanceof TextWriteable) {
            ((TextWriteable)this.getModel()).writeToText(textWriterStream, string);
        }
    }

    public boolean isNoise() {
        return this.noise;
    }

    public void setNoise(boolean bl) {
        this.noise = bl;
    }

    public String toString() {
        String string = this.model == null ? "null" : this.model.toString();
        String string2 = this.noise ? ",noise" : "";
        return "Cluster(size=" + this.size() + ",model=" + string + string2 + ")";
    }
}

