/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.ClassLabel;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import java.util.regex.Pattern;

public class HierarchicalClassLabel
extends ClassLabel {
    public static final Pattern DEFAULT_SEPARATOR = Pattern.compile("\\.");
    public static final String DEFAULT_SEPARATOR_STRING = ".";
    public static final SimpleTypeInformation<HierarchicalClassLabel> TYPE = new SimpleTypeInformation<HierarchicalClassLabel>(HierarchicalClassLabel.class);
    private Pattern separatorPattern;
    private String separatorString;
    private Comparable<?>[] levelwiseNames;

    public HierarchicalClassLabel(String string, Pattern pattern, String string2) {
        this.separatorPattern = pattern;
        this.separatorString = string2;
        String[] stringArray = this.separatorPattern.split(string);
        this.levelwiseNames = new Comparable[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.levelwiseNames[i] = Integer.valueOf(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                this.levelwiseNames[i] = stringArray[i];
            }
        }
    }

    public HierarchicalClassLabel(String string) {
        this(string, DEFAULT_SEPARATOR, DEFAULT_SEPARATOR_STRING);
    }

    @Override
    public int compareTo(ClassLabel classLabel) {
        HierarchicalClassLabel hierarchicalClassLabel = (HierarchicalClassLabel)classLabel;
        for (int i = 0; i < this.levelwiseNames.length && i < hierarchicalClassLabel.levelwiseNames.length; ++i) {
            Object object;
            int n = 0;
            try {
                Comparable<?> comparable = this.levelwiseNames[i];
                object = hierarchicalClassLabel.levelwiseNames[i];
                n = comparable.compareTo(object);
            }
            catch (RuntimeException runtimeException) {
                object = (String)(this.levelwiseNames[i] instanceof Integer ? this.levelwiseNames[i].toString() : this.levelwiseNames[i]);
                String string = (String)(hierarchicalClassLabel.levelwiseNames[i] instanceof Integer ? hierarchicalClassLabel.levelwiseNames[i].toString() : hierarchicalClassLabel.levelwiseNames[i]);
                n = ((String)object).compareTo(string);
            }
            if (n == 0) continue;
            return n;
        }
        return this.levelwiseNames.length < hierarchicalClassLabel.levelwiseNames.length ? -1 : (this.levelwiseNames.length == hierarchicalClassLabel.levelwiseNames.length ? 0 : 1);
    }

    public int depth() {
        return this.levelwiseNames.length - 1;
    }

    public String getNameAt(int n) {
        return this.levelwiseNames[n] instanceof Integer ? this.levelwiseNames[n].toString() : (String)((Object)this.levelwiseNames[n]);
    }

    @Override
    public String toString() {
        return this.toString(this.levelwiseNames.length);
    }

    public String toString(int n) {
        if (n > this.levelwiseNames.length) {
            throw new IllegalArgumentException("Specified level exceeds depth of hierarchy.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.getNameAt(i));
            if (i >= n - 1) continue;
            stringBuilder.append(this.separatorString);
        }
        return stringBuilder.toString();
    }

    public static class Factory
    extends ClassLabel.Factory<HierarchicalClassLabel> {
        @Override
        public HierarchicalClassLabel makeFromString(String string) {
            HierarchicalClassLabel hierarchicalClassLabel = (HierarchicalClassLabel)this.existing.get(string = string.intern());
            if (hierarchicalClassLabel == null) {
                hierarchicalClassLabel = new HierarchicalClassLabel(string);
                this.existing.put(string, hierarchicalClassLabel);
            }
            return hierarchicalClassLabel;
        }

        @Override
        public SimpleTypeInformation<? super HierarchicalClassLabel> getTypeInformation() {
            return TYPE;
        }
    }
}

