/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.parser;

import de.lmu.ifi.dbs.elki.data.BitVector;
import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.datasource.parser.AbstractStreamingParser;
import de.lmu.ifi.dbs.elki.datasource.parser.CSVReaderFormat;
import de.lmu.ifi.dbs.elki.datasource.parser.NumberVectorLabelParser;
import de.lmu.ifi.dbs.elki.datasource.parser.Parser;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import gnu.trove.list.array.TLongArrayList;

@Title(value="Bit Vector Label Parser")
@Description(value="Parses the following format of lines:\nA single line provides a single BitVector. Bits are separated by whitespace. Any substring not containing whitespace is tried to be read as Bit. If this fails, it will be appended to a label. (Thus, any label must not be parseable as Bit.) Empty lines and lines beginning with \"#\" will be ignored.")
@Alias(value={"de.lmu.ifi.dbs.elki.parser.BitVectorLabelParser"})
public class BitVectorLabelParser
extends NumberVectorLabelParser<BitVector>
implements Parser {
    private static final Logging LOG = Logging.getLogger(BitVectorLabelParser.class);
    TLongArrayList buf = new TLongArrayList();

    public BitVectorLabelParser(CSVReaderFormat cSVReaderFormat) {
        super(cSVReaderFormat, null, BitVector.FACTORY);
    }

    @Override
    protected boolean parseLineInternal() {
        int n = 0;
        while (this.tokenizer.valid()) {
            try {
                int n2 = n >>> 6;
                int n3 = n & 0x3F;
                if (n2 >= this.buf.size()) {
                    this.buf.add(0L);
                }
                if (this.tokenizer.getLongBase10() > 0L) {
                    this.buf.set(n2, this.buf.get(n2) | 1L << n3);
                }
                ++n;
            }
            catch (NumberFormatException numberFormatException) {
                this.labels.add(this.tokenizer.getSubstring());
            }
            this.tokenizer.advance();
        }
        if (n == 0) {
            return false;
        }
        this.curvec = new BitVector(this.buf.toArray(), n);
        this.curlbl = LabelList.make(this.labels);
        this.buf.clear();
        this.labels.clear();
        return true;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractStreamingParser.Parameterizer {
        @Override
        protected BitVectorLabelParser makeInstance() {
            return new BitVectorLabelParser(this.format);
        }
    }
}

