/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.timeseries;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

public abstract class AbstractEditDistanceFunction
extends AbstractNumberVectorDistanceFunction {
    protected double bandSize;

    public AbstractEditDistanceFunction(double d) {
        this.bandSize = d;
    }

    protected int effectiveBandSize(int n, int n2) {
        if (this.bandSize == Double.POSITIVE_INFINITY) {
            return n > n2 ? n : n2;
        }
        if (this.bandSize >= 1.0) {
            return (int)this.bandSize;
        }
        return (int)Math.ceil((double)(n >= n2 ? n : n2) * this.bandSize);
    }

    @Override
    public VectorTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        return this.bandSize == ((AbstractEditDistanceFunction)object).bandSize;
    }

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID BANDSIZE_ID = new OptionID("edit.bandsize", "The band size for time series alignment. By default, no constraint is used. If the value is larger than 0, it will be considered absolute, otherwise relative to the longer sequence. Note that 0 does not make sense: use Euclidean distance then instead.");
        protected double bandSize = Double.POSITIVE_INFINITY;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = (DoubleParameter)((DoubleParameter)new DoubleParameter(BANDSIZE_ID).setOptional(true)).addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.bandSize = doubleParameter.doubleValue();
            }
        }
    }
}

