/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result;

import de.lmu.ifi.dbs.elki.gui.GUIUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHandler;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.StringParameter;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.VisualizerParameterizer;
import de.lmu.ifi.dbs.elki.visualization.gui.ResultWindow;
import javax.swing.SwingUtilities;

@Alias(value={"visualizer", "vis", "ResultVisualizer", "de.lmu.ifi.dbs.elki.visualization.gui.ResultVisualizer"})
public class AutomaticVisualization
implements ResultHandler {
    private static final Logging LOG = Logging.getLogger(AutomaticVisualization.class);
    String title;
    protected static final String DEFAULT_TITLE = "ELKI Result Visualization";
    VisualizerParameterizer manager;
    boolean single;
    ResultWindow window;

    public AutomaticVisualization(String string, VisualizerParameterizer visualizerParameterizer, boolean bl) {
        this.title = string;
        this.manager = visualizerParameterizer;
        this.single = bl;
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        if (this.window == null) {
            if (this.title == null) {
                this.title = VisualizerParameterizer.getTitle(ResultUtil.findDatabase(resultHierarchy), result);
                if (this.title == null) {
                    this.title = DEFAULT_TITLE;
                }
            }
            GUIUtil.setLookAndFeel();
            VisualizerContext visualizerContext = this.manager.newContext(resultHierarchy, result);
            this.window = new ResultWindow(this.title, visualizerContext, this.single);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    AutomaticVisualization.this.window.setVisible(true);
                    AutomaticVisualization.this.window.setExtendedState(AutomaticVisualization.this.window.getExtendedState() | 6);
                }
                catch (Throwable throwable) {
                    LOG.exception("Error in starting visualizer window.", throwable);
                }
            }
        });
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID WINDOW_TITLE_ID = new OptionID("vis.window.title", "Title to use for visualization window.");
        public static final OptionID SINGLE_ID = new OptionID("vis.window.single", "Embed visualizers in a single window, not using thumbnails and detail views.");
        String title;
        VisualizerParameterizer manager;
        boolean single = false;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            super.makeOptions(parameterization);
            StringParameter stringParameter = new StringParameter(WINDOW_TITLE_ID);
            stringParameter.setOptional(true);
            if (parameterization.grab(stringParameter)) {
                this.title = (String)stringParameter.getValue();
            }
            if (parameterization.grab(flag = new Flag(SINGLE_ID))) {
                this.single = flag.isTrue();
            }
            this.manager = parameterization.tryInstantiate(VisualizerParameterizer.class);
        }

        @Override
        protected AutomaticVisualization makeInstance() {
            return new AutomaticVisualization(this.title, this.manager, this.single);
        }
    }
}

