/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot;

import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractTooltipVisualization;
import java.text.NumberFormat;
import java.util.Locale;
import org.w3c.dom.Element;

public class TooltipScoreVisualization
extends AbstractVisFactory {
    public static final String NAME = "Outlier Score Tooltips";
    public static final String NAME_GEN = " Tooltips";
    protected Parameterizer settings;

    public TooltipScoreVisualization(Parameterizer parameterizer) {
        this.settings = parameterizer;
    }

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        final ResultHierarchy resultHierarchy = visualizerContext.getHierarchy();
        VisualizationTree.findNewSiblings(visualizerContext, object, OutlierResult.class, ScatterPlotProjector.class, new VisualizationTree.Handler2<OutlierResult, ScatterPlotProjector<?>>(){

            @Override
            public void process(VisualizerContext visualizerContext, OutlierResult outlierResult, ScatterPlotProjector<?> scatterPlotProjector) {
                Relation<?> relation = scatterPlotProjector.getRelation();
                if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                    return;
                }
                VisualizationTask visualizationTask = new VisualizationTask(outlierResult.getLongName() + TooltipScoreVisualization.NAME_GEN, visualizerContext, outlierResult.getScores(), relation, TooltipScoreVisualization.this);
                visualizationTask.tool = true;
                visualizationTask.addUpdateFlags(9);
                visualizationTask.initDefaultVisibility(false);
                visualizerContext.addVis(outlierResult.getScores(), visualizationTask);
                visualizerContext.addVis(scatterPlotProjector, visualizationTask);
            }
        });
        VisualizationTree.findNewSiblings(visualizerContext, object, DoubleRelation.class, ScatterPlotProjector.class, new VisualizationTree.Handler2<DoubleRelation, ScatterPlotProjector<?>>(){

            @Override
            public void process(VisualizerContext visualizerContext, DoubleRelation doubleRelation, ScatterPlotProjector<?> scatterPlotProjector) {
                Relation<?> relation = resultHierarchy.iterParents(doubleRelation);
                while (relation.valid()) {
                    if (relation.get() instanceof OutlierResult) {
                        return;
                    }
                    relation.advance();
                }
                relation = scatterPlotProjector.getRelation();
                if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                    return;
                }
                VisualizationTask visualizationTask = new VisualizationTask(doubleRelation.getLongName() + TooltipScoreVisualization.NAME_GEN, visualizerContext, doubleRelation, relation, TooltipScoreVisualization.this);
                visualizationTask.tool = true;
                visualizationTask.addUpdateFlags(9);
                visualizationTask.initDefaultVisibility(false);
                visualizerContext.addVis(doubleRelation, visualizationTask);
                visualizerContext.addVis(scatterPlotProjector, visualizationTask);
            }
        });
        VisualizationTree.findNewSiblings(visualizerContext, object, Relation.class, ScatterPlotProjector.class, new VisualizationTree.Handler2<Relation<?>, ScatterPlotProjector<?>>(){

            @Override
            public void process(VisualizerContext visualizerContext, Relation<?> relation, ScatterPlotProjector<?> scatterPlotProjector) {
                if (relation instanceof DoubleRelation) {
                    return;
                }
                if (!TypeUtil.DOUBLE.isAssignableFromType(relation.getDataTypeInformation()) && !TypeUtil.INTEGER.isAssignableFromType(relation.getDataTypeInformation())) {
                    return;
                }
                Relation<?> relation2 = scatterPlotProjector.getRelation();
                if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation2.getDataTypeInformation())) {
                    return;
                }
                VisualizationTask visualizationTask = new VisualizationTask(relation.getLongName() + TooltipScoreVisualization.NAME_GEN, visualizerContext, relation, relation2, TooltipScoreVisualization.this);
                visualizationTask.tool = true;
                visualizationTask.addUpdateFlags(9);
                visualizationTask.initDefaultVisibility(false);
                visualizerContext.addVis(relation, visualizationTask);
                visualizerContext.addVis(scatterPlotProjector, visualizationTask);
            }
        });
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        NumberFormat nf = null;
        public static final OptionID DIGITS_ID = new OptionID("tooltip.digits", "Number of digits to show (e.g. when visualizing outlier scores)");

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(DIGITS_ID, 4);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (parameterization.grab(intParameter)) {
                int n = intParameter.intValue();
                this.nf = NumberFormat.getInstance(Locale.ROOT);
                this.nf.setGroupingUsed(false);
                this.nf.setMaximumFractionDigits(n);
            }
        }

        @Override
        protected TooltipScoreVisualization makeInstance() {
            return new TooltipScoreVisualization(this);
        }
    }

    public class Instance
    extends AbstractTooltipVisualization {
        private Relation<? extends Number> result;
        private double fontsize;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.result = (Relation)visualizationTask.getResult();
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            this.fontsize = 3.0 * styleLibrary.getTextSize("plot");
            this.addListeners();
        }

        @Override
        protected Element makeTooltip(DBIDRef dBIDRef, double d, double d2, double d3) {
            return this.svgp.svgText(d + d3, d2 + this.fontsize * 0.07, TooltipScoreVisualization.this.settings.nf.format(this.result.get(dBIDRef).doubleValue()));
        }

        @Override
        protected void setupCSS(SVGPlot sVGPlot) {
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            double d = styleLibrary.getTextSize("plot");
            String string = styleLibrary.getFontFamily("plot");
            CSSClass cSSClass = new CSSClass(sVGPlot, "tooltip_hidden");
            cSSClass.setStatement("font-size", d);
            cSSClass.setStatement("font-family", string);
            cSSClass.setStatement("display", "none");
            sVGPlot.addCSSClassOrLogError(cSSClass);
            CSSClass cSSClass2 = new CSSClass(sVGPlot, "tooltip_visible");
            cSSClass2.setStatement("font-size", d);
            cSSClass2.setStatement("font-family", string);
            sVGPlot.addCSSClassOrLogError(cSSClass2);
            CSSClass cSSClass3 = new CSSClass(sVGPlot, "tooltip_sticky");
            cSSClass3.setStatement("font-size", d);
            cSSClass3.setStatement("font-family", string);
            sVGPlot.addCSSClassOrLogError(cSSClass3);
            CSSClass cSSClass4 = new CSSClass(sVGPlot, "tooltip_area");
            cSSClass4.setStatement("fill", "red");
            cSSClass4.setStatement("stroke", "none");
            cSSClass4.setStatement("fill-opacity", "0");
            cSSClass4.setStatement("cursor", "pointer");
            sVGPlot.addCSSClassOrLogError(cSSClass4);
            sVGPlot.updateStyleElement();
        }
    }
}

