/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan;

import de.lmu.ifi.dbs.elki.algorithm.clustering.correlation.FourC;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.CorePredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.PreDeConNeighborPredicate;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;

@Reference(authors="C. B\u00f6hm, K. Kailing, P. Kr\u00f6ger, A. Zimek", title="Computing Clusters of Correlation Connected Objects", booktitle="Proc. ACM SIGMOD Int. Conf. on Management of Data, Paris, France, 2004, 455-466", url="http://dx.doi.org/10.1145/1007568.1007620")
public class FourCCorePredicate
implements CorePredicate {
    protected FourC.Settings settings;

    public FourCCorePredicate(FourC.Settings settings) {
        this.settings = settings;
    }

    @Override
    public <T> CorePredicate.Instance<T> instantiate(Database database, SimpleTypeInformation<?> simpleTypeInformation) {
        return new Instance(this.settings);
    }

    @Override
    public boolean acceptsType(SimpleTypeInformation<?> simpleTypeInformation) {
        return simpleTypeInformation.getRestrictionClass().isAssignableFrom(PreDeConNeighborPredicate.PreDeConModel.class);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected FourC.Settings settings;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            this.settings = parameterization.tryInstantiate(FourC.Settings.class);
        }

        @Override
        protected FourCCorePredicate makeInstance() {
            return new FourCCorePredicate(this.settings);
        }
    }

    public static class Instance
    implements CorePredicate.Instance<PreDeConNeighborPredicate.PreDeConModel> {
        protected FourC.Settings settings;

        public Instance(FourC.Settings settings) {
            this.settings = settings;
        }

        @Override
        public boolean isCorePoint(DBIDRef dBIDRef, PreDeConNeighborPredicate.PreDeConModel preDeConModel) {
            return preDeConModel.pdim <= this.settings.lambda && preDeConModel.ids.size() >= this.settings.minpts;
        }
    }
}

