/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.AbstractKMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeansLloyd;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.PredefinedInitialMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.quality.KMeansQualityMeasure;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ProxyDatabase;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.MutableProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.LessEqualGlobalConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ChainedParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

@Reference(authors="D. Pelleg, A. Moore", booktitle="X-means: Extending K-means with Efficient Estimation on the Number of Clusters", title="Proceedings of the 17th International Conference on Machine Learning (ICML 2000)", url="http://www.pelleg.org/shared/hp/download/xmeans.ps")
public class XMeans<V extends NumberVector, M extends MeanModel>
extends AbstractKMeans<V, M> {
    private static final Logging LOG = Logging.getLogger(XMeans.class);
    private static final String KEY = XMeans.class.getName();
    private KMeans<V, M> innerKMeans;
    private int k;
    private int k_min;
    private int k_max;
    PredefinedInitialMeans splitInitializer;
    KMeansQualityMeasure<V> informationCriterion;
    RandomFactory rnd;

    public XMeans(NumberVectorDistanceFunction<? super V> numberVectorDistanceFunction, int n, int n2, int n3, KMeans<V, M> kMeans, KMeansInitialization<? super V> kMeansInitialization, PredefinedInitialMeans predefinedInitialMeans, KMeansQualityMeasure<V> kMeansQualityMeasure, RandomFactory randomFactory) {
        super(numberVectorDistanceFunction, n, n3, kMeansInitialization);
        this.k_min = n;
        this.k_max = n2;
        this.k = n;
        this.innerKMeans = kMeans;
        this.splitInitializer = predefinedInitialMeans;
        this.informationCriterion = kMeansQualityMeasure;
        this.rnd = randomFactory;
    }

    @Override
    public Clustering<M> run(Database database, Relation<V> relation) {
        Object object;
        MutableProgress mutableProgress = LOG.isVerbose() ? new MutableProgress("X-means number of clusters", this.k_max, LOG) : null;
        this.innerKMeans.setK(this.k_min);
        if (LOG.isStatistics()) {
            LOG.statistics(new StringStatistic(KEY + ".initialization", this.initializer.toString()));
        }
        this.splitInitializer.setInitialMeans(this.initializer.chooseInitialMeans(database, relation, this.k_min, this.getDistanceFunction(), Vector.FACTORY));
        Clustering<M> clustering = this.innerKMeans.run(database, relation);
        if (mutableProgress != null) {
            mutableProgress.setProcessed(this.k_min, LOG);
        }
        ArrayList<Cluster<M>> arrayList = new ArrayList<Cluster<M>>(clustering.getAllClusters());
        while (arrayList.size() <= this.k_max) {
            object = new ArrayList();
            for (Cluster<M> cluster : arrayList) {
                List<Cluster<M>> list = this.splitCluster(cluster, database, relation);
                ((ArrayList)object).addAll(list);
                if (list.size() <= 1) continue;
                this.k += list.size() - 1;
                if (mutableProgress == null) continue;
                if (this.k >= this.k_max) {
                    mutableProgress.setTotal(this.k + 1);
                }
                mutableProgress.setProcessed(this.k, LOG);
            }
            if (arrayList.size() == ((ArrayList)object).size()) break;
            this.splitInitializer.setInitialClusters((List<? extends Cluster<? extends MeanModel>>)object);
            this.innerKMeans.setK(((ArrayList)object).size());
            clustering = this.innerKMeans.run(database, relation);
            arrayList.clear();
            arrayList.addAll(clustering.getAllClusters());
        }
        if (mutableProgress != null) {
            mutableProgress.setTotal(this.k);
            mutableProgress.setProcessed(this.k, LOG);
        }
        if (LOG.isDebugging()) {
            LOG.debug("X-means returned k=" + this.k + " clusters.");
        }
        object = new Clustering<M>("X-Means Result", "X-Means", arrayList);
        return object;
    }

    protected List<Cluster<M>> splitCluster(Cluster<M> cluster, Database database, Relation<V> relation) {
        ArrayList arrayList = new ArrayList(1);
        arrayList.add(cluster);
        Clustering clustering = new Clustering(cluster.getName(), cluster.getName(), arrayList);
        if (cluster.size() < 2) {
            return arrayList;
        }
        ProxyDatabase proxyDatabase = new ProxyDatabase(cluster.getIDs(), database);
        this.splitInitializer.setInitialMeans(this.splitCentroid(cluster, relation));
        this.innerKMeans.setK(2);
        Object c = this.innerKMeans.run(proxyDatabase);
        double d = this.informationCriterion.quality(clustering, this.getDistanceFunction(), relation);
        double d2 = this.informationCriterion.quality((Clustering<MeanModel>)c, this.getDistanceFunction(), relation);
        if (LOG.isDebugging()) {
            LOG.debug("parentEvaluation: " + d);
            LOG.debug("childrenEvaluation: " + d2);
        }
        return d2 > d ^ this.informationCriterion.ascending() ? arrayList : ((Clustering)c).getAllClusters();
    }

    protected List<? extends NumberVector> splitCentroid(Cluster<? extends MeanModel> cluster, Relation<V> relation) {
        Vector vector = cluster.getModel().getMean();
        double d = 0.0;
        Object object = cluster.getIDs().iter();
        while (object.valid()) {
            double d2 = this.getDistanceFunction().distance((NumberVector)relation.get((DBIDRef)object), vector);
            d = d2 > d ? d2 : d;
            object.advance();
        }
        object = this.rnd.getSingleThreadedRandom();
        int n = RelationUtil.dimensionality(relation);
        Vector vector2 = VectorUtil.randomVector(Vector.FACTORY, n, (Random)object).normalize();
        vector2.timesEquals((0.4 + ((Random)object).nextDouble() * 0.5) * d);
        ArrayList<Vector> arrayList = new ArrayList<Vector>(2);
        arrayList.add(vector.minus(vector2));
        arrayList.add(vector2.plusEquals(vector));
        return arrayList;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return this.innerKMeans.getInputTypeRestriction();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector, M extends MeanModel>
    extends AbstractKMeans.Parameterizer<V> {
        public static final OptionID INNER_KMEANS_ID = new OptionID("xmeans.kmeans", "kMeans algorithm to use.");
        public static final OptionID K_MIN_ID = new OptionID("xmeans.k_min", "The minimum number of clusters to find.");
        public static final OptionID SEED_ID = new OptionID("xmeans.seed", "Random seed for splitting clusters.");
        public static final OptionID INFORMATION_CRITERION_ID = new OptionID("xmeans.quality", "The quality measure to evaluate splits (e.g. AIC, BIC)");
        protected KMeans<V, M> innerKMeans;
        protected PredefinedInitialMeans splitInitializer;
        protected KMeansQualityMeasure<V> informationCriterion;
        protected int k_min;
        protected int k_max;
        private RandomFactory random;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Object object;
            IntParameter intParameter;
            IntParameter intParameter2 = (IntParameter)new IntParameter(K_MIN_ID, 2).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter2)) {
                this.k_min = intParameter2.intValue();
            }
            if (parameterization.grab(intParameter = (IntParameter)new IntParameter(KMeans.K_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.k_max = intParameter.intValue();
            }
            parameterization.checkConstraint(new LessEqualGlobalConstraint<Integer>(intParameter2, intParameter));
            this.getParameterInitialization(parameterization);
            this.getParameterMaxIter(parameterization);
            this.getParameterDistanceFunction(parameterization);
            RandomParameter randomParameter = new RandomParameter(SEED_ID);
            if (parameterization.grab(randomParameter)) {
                this.random = (RandomFactory)randomParameter.getValue();
            }
            this.splitInitializer = new PredefinedInitialMeans((List<? extends NumberVector>)null);
            ObjectParameter objectParameter = new ObjectParameter(INNER_KMEANS_ID, (Class<?>)KMeans.class, KMeansLloyd.class);
            if (parameterization.grab(objectParameter)) {
                object = new ListParameterization();
                ((ListParameterization)object).addParameter(KMeans.K_ID, this.k_min);
                ((ListParameterization)object).addParameter(KMeans.INIT_ID, this.splitInitializer);
                ((ListParameterization)object).addParameter(KMeans.MAXITER_ID, this.maxiter);
                ((ListParameterization)object).addParameter(KMeans.DISTANCE_FUNCTION_ID, this.distanceFunction);
                ChainedParameterization chainedParameterization = new ChainedParameterization(new Parameterization[]{object, parameterization});
                chainedParameterization.errorsTo(parameterization);
                this.innerKMeans = (KMeans)objectParameter.instantiateClass(chainedParameterization);
            }
            if (parameterization.grab((Parameter<?>)(object = new ObjectParameter(INFORMATION_CRITERION_ID, KMeansQualityMeasure.class)))) {
                this.informationCriterion = (KMeansQualityMeasure)((ObjectParameter)object).instantiateClass(parameterization);
            }
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }

        @Override
        protected XMeans<V, M> makeInstance() {
            return new XMeans<V, M>(this.distanceFunction, this.k_min, this.k_max, this.maxiter, this.innerKMeans, this.initializer, this.splitInitializer, this.informationCriterion, this.random);
        }
    }
}

