/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.itemsetmining;

import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.Itemset;
import de.lmu.ifi.dbs.elki.data.BitVector;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;

public class DenseItemset
extends Itemset {
    long[] items;
    int length;

    public DenseItemset(long[] lArray, int n) {
        this.items = lArray;
        this.length = n;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public boolean containedIn(BitVector bitVector) {
        return bitVector.contains(this.items);
    }

    @Override
    public long[] getItems() {
        return this.items;
    }

    public int hashCode() {
        return BitsUtil.hashCode(this.items);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Itemset) || ((Itemset)object).length() != 1) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return BitsUtil.equal(this.items, ((DenseItemset)object).items);
    }

    @Override
    public int compareTo(Itemset itemset) {
        int n = Integer.compare(this.length, itemset.length());
        if (n != 0) {
            return n;
        }
        DenseItemset denseItemset = (DenseItemset)itemset;
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == denseItemset.items[i]) continue;
            return -Long.compare(Long.reverse(this.items[i]), Long.reverse(denseItemset.items[i]));
        }
        return 0;
    }

    @Override
    public StringBuilder appendTo(StringBuilder stringBuilder, VectorFieldTypeInformation<BitVector> vectorFieldTypeInformation) {
        int n = BitsUtil.nextSetBit(this.items, 0);
        while (true) {
            String string;
            String string2 = string = vectorFieldTypeInformation != null ? vectorFieldTypeInformation.getLabel(n) : null;
            if (string == null) {
                stringBuilder.append(n);
            } else {
                stringBuilder.append(string);
            }
            n = BitsUtil.nextSetBit(this.items, n + 1);
            if (n < 0) break;
            stringBuilder.append(", ");
        }
        stringBuilder.append(": ").append(this.support);
        return stringBuilder;
    }
}

