/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.generic.MaskedDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.CovarianceMatrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

@Title(value="Gaussian-Uniform Mixture Model Outlier Detection")
@Description(value="Fits a mixture model consisting of a Gaussian and a uniform distribution to the data.")
@Reference(prefix="Generalization using the likelihood gain as outlier score of", authors="E. Eskin", title="Anomaly detection over noisy data using learned probability distributions", booktitle="Proc. of the Seventeenth International Conference on Machine Learning (ICML-2000)")
public class GaussianUniformMixture<V extends NumberVector>
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(GaussianUniformMixture.class);
    private static final double SINGULARITY_CHEAT = 1.0E-9;
    private double c;
    private double logl;
    private double logml;

    public GaussianUniformMixture(double d, double d2) {
        this.logl = Math.log(d);
        this.logml = Math.log(1.0 - d);
        this.c = d2;
    }

    public OutlierResult run(Relation<V> relation) {
        ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(relation.getDBIDs());
        long[] lArray = BitsUtil.zero(arrayDBIDs.size());
        MaskedDBIDs maskedDBIDs = new MaskedDBIDs(arrayDBIDs, lArray, true);
        MaskedDBIDs maskedDBIDs2 = new MaskedDBIDs(arrayDBIDs, lArray, false);
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 3);
        double d = (double)relation.size() * this.logml + this.loglikelihoodNormal(maskedDBIDs, relation);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        for (int i = 0; i < arrayDBIDs.size(); ++i) {
            BitsUtil.setI(lArray, i);
            double d2 = (double)maskedDBIDs.size() * this.logml + this.loglikelihoodNormal(maskedDBIDs, relation) + (double)maskedDBIDs2.size() * this.logl + this.loglikelihoodAnomalous(maskedDBIDs2);
            double d3 = d2 - d;
            writableDoubleDataStore.putDouble(dBIDArrayIter, d3);
            doubleMinMax.put(d3);
            if (d3 > this.c) {
                d = d2;
            } else {
                BitsUtil.clearI(lArray, i);
            }
            dBIDArrayIter.advance();
        }
        BasicOutlierScoreMeta basicOutlierScoreMeta = new BasicOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        MaterializedDoubleRelation materializedDoubleRelation = new MaterializedDoubleRelation("Gaussian Mixture Outlier Score", "gaussian-mixture-outlier", writableDoubleDataStore, relation.getDBIDs());
        return new OutlierResult(basicOutlierScoreMeta, materializedDoubleRelation);
    }

    private double loglikelihoodAnomalous(DBIDs dBIDs) {
        int n = dBIDs.size();
        return (double)n * Math.log(1.0 / (double)n);
    }

    private double loglikelihoodNormal(DBIDs dBIDs, Relation<V> relation) {
        if (dBIDs.isEmpty()) {
            return 0.0;
        }
        CovarianceMatrix covarianceMatrix = CovarianceMatrix.make(relation, dBIDs);
        Vector vector = covarianceMatrix.getMeanVector();
        Matrix matrix = covarianceMatrix.destroyToSampleMatrix();
        Matrix matrix2 = matrix.cheatToAvoidSingularity(1.0E-9).inverse();
        double d = matrix.det();
        double d2 = 1.0 / Math.sqrt(MathUtil.powi(Math.PI * 2, RelationUtil.dimensionality(relation)) * d);
        double d3 = 0.0;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            Vector vector2 = ((NumberVector)relation.get(dBIDIter)).getColumnVector().minusEquals(vector);
            double d4 = vector2.transposeTimesTimes(matrix2, vector2);
            d3 += Math.log(d2 * Math.exp(-d4 / 2.0));
            dBIDIter.advance();
        }
        return d3;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID L_ID = new OptionID("mmo.l", "expected fraction of outliers");
        public static final OptionID C_ID = new OptionID("mmo.c", "cutoff");
        protected double l = 1.0E-7;
        protected double c = 0.0;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = new DoubleParameter(C_ID, 1.0E-7);
            if (parameterization.grab(doubleParameter2)) {
                this.l = (Double)doubleParameter2.getValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(C_ID, 1.0E-7))) {
                this.c = (Double)doubleParameter.getValue();
            }
        }

        @Override
        protected GaussianUniformMixture<V> makeInstance() {
            return new GaussianUniformMixture(this.l, this.c);
        }
    }
}

