/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.AbstractOPTICS;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.QuotientOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;
import java.util.List;

@Title(value="OPTICS-OF: Identifying Local Outliers")
@Description(value="Algorithm to compute density-based local outlier factors in a database based on the neighborhood size parameter 'minpts'")
@Reference(authors="M. M. Breunig, H.-P. Kriegel, R. Ng, and J. Sander", title="OPTICS-OF: Identifying Local Outliers", booktitle="Proc. of the 3rd European Conference on Principles of Knowledge Discovery and Data Mining (PKDD), Prague, Czech Republic", url="http://springerlink.metapress.com/content/76bx6413gqb4tvta/")
public class OPTICSOF<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(OPTICSOF.class);
    private int minpts;

    public OPTICSOF(DistanceFunction<? super O> distanceFunction, int n) {
        super(distanceFunction);
        this.minpts = n;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        Object object;
        Object object2;
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> kNNQuery = database.getKNNQuery(distanceQuery, this.minpts);
        RangeQuery<O> rangeQuery = database.getRangeQuery(distanceQuery, new Object[0]);
        DBIDs dBIDs = relation.getDBIDs();
        WritableDataStore<KNNList> writableDataStore = DataStoreUtil.makeStorage(dBIDs, 3, KNNList.class);
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 3);
        WritableIntegerDataStore writableIntegerDataStore = DataStoreUtil.makeIntegerStorage(dBIDs, 3, -1);
        Object object3 = relation.iterDBIDs();
        while (object3.valid()) {
            object2 = kNNQuery.getKNNForDBID((DBIDRef)object3, this.minpts);
            double d = object2.getKNNDistance();
            writableDataStore.put((DBIDRef)object3, (KNNList)object2);
            writableDoubleDataStore.putDouble((DBIDRef)object3, d);
            writableIntegerDataStore.put((DBIDRef)object3, rangeQuery.getRangeForDBID((DBIDRef)object3, d).size());
            object3.advance();
        }
        object3 = DataStoreUtil.makeStorage(dBIDs, 3, List.class);
        object2 = DataStoreUtil.makeDoubleStorage(dBIDs, 3);
        Object object4 = relation.iterDBIDs();
        while (object4.valid()) {
            object = new ArrayList();
            double d = 0.0;
            DoubleDBIDListIter doubleDBIDListIter = ((KNNList)writableDataStore.get((DBIDRef)object4)).iter();
            while (doubleDBIDListIter.valid()) {
                double d2 = writableDoubleDataStore.doubleValue(doubleDBIDListIter);
                double d3 = distanceQuery.distance((DBIDRef)object4, (DBIDRef)doubleDBIDListIter);
                double d4 = MathUtil.max(d2, d3);
                d = d4 + d;
                object.add(d4);
                doubleDBIDListIter.advance();
            }
            d = (double)writableIntegerDataStore.intValue((DBIDRef)object4) / d;
            object3.put((DBIDRef)object4, object);
            object2.putDouble((DBIDRef)object4, d);
            object4.advance();
        }
        object4 = new DoubleMinMax();
        object = DataStoreUtil.makeDoubleStorage(dBIDs, 4);
        Object object5 = relation.iterDBIDs();
        while (object5.valid()) {
            double d = 0.0;
            DoubleDBIDListIter doubleDBIDListIter = ((KNNList)writableDataStore.get((DBIDRef)object5)).iter();
            while (doubleDBIDListIter.valid()) {
                double d5 = object2.doubleValue((DBIDRef)object5);
                double d6 = object2.doubleValue(doubleDBIDListIter);
                d += d6 / d5;
                doubleDBIDListIter.advance();
            }
            object.putDouble((DBIDRef)object5, d /= (double)writableIntegerDataStore.intValue((DBIDRef)object5));
            ((DoubleMinMax)object4).put(d);
            object5.advance();
        }
        object5 = new MaterializedDoubleRelation("OPTICS Outlier Scores", "optics-outlier", (DoubleDataStore)object, relation.getDBIDs());
        QuotientOutlierScoreMeta quotientOutlierScoreMeta = new QuotientOutlierScoreMeta(((DoubleMinMax)object4).getMin(), ((DoubleMinMax)object4).getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        return new OutlierResult(quotientOutlierScoreMeta, (DoubleRelation)object5);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        protected int minpts = 0;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(AbstractOPTICS.Parameterizer.MINPTS_ID).addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.minpts = (Integer)intParameter.getValue();
            }
        }

        @Override
        protected OPTICSOF<O> makeInstance() {
            return new OPTICSOF(this.distanceFunction, this.minpts);
        }
    }
}

