/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.anglebased;

import de.lmu.ifi.dbs.elki.algorithm.outlier.anglebased.ABOD;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel.KernelMatrix;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.GreaterEqualConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="Approximate ABOD: Angle-Based Outlier Detection")
@Description(value="Outlier detection using variance analysis on angles, especially for high dimensional data sets.")
@Reference(authors="H.-P. Kriegel, M. Schubert, A. Zimek", title="Angle-Based Outlier Detection in High-dimensional Data", booktitle="Proc. 14th ACM SIGKDD Int. Conf. on Knowledge Discovery and Data Mining (KDD '08), Las Vegas, NV, 2008", url="http://dx.doi.org/10.1145/1401890.1401946")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.FastABOD", "fastabod"})
public class FastABOD<V extends NumberVector>
extends ABOD<V> {
    private static final Logging LOG = Logging.getLogger(FastABOD.class);
    protected int k;

    public FastABOD(SimilarityFunction<? super V> similarityFunction, int n) {
        super(similarityFunction);
        this.k = n;
    }

    @Override
    public OutlierResult run(Database database, Relation<V> relation) {
        DBIDs dBIDs = relation.getDBIDs();
        SimilarityQuery<V> similarityQuery = database.getSimilarityQuery(relation, this.kernelFunction, new Object[0]);
        KernelMatrix kernelMatrix = new KernelMatrix(similarityQuery, relation, dBIDs);
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 4);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        MeanVariance meanVariance = new MeanVariance();
        KNNHeap kNNHeap = DBIDUtil.newHeap(this.k);
        Object object = dBIDs.iter();
        while (object.valid()) {
            double d;
            double d2;
            double d3 = kernelMatrix.getSimilarity((DBIDRef)object, (DBIDRef)object);
            kNNHeap.clear();
            Object object2 = relation.iterDBIDs();
            while (object2.valid()) {
                double d4;
                if (!DBIDUtil.equal((DBIDRef)object2, (DBIDRef)object) && (d2 = d3 + (d4 = kernelMatrix.getSimilarity((DBIDRef)object2, (DBIDRef)object2)) - (d = kernelMatrix.getSimilarity((DBIDRef)object, (DBIDRef)object2)) - d) > 0.0) {
                    kNNHeap.insert(d2, (DBIDRef)object2);
                }
                object2.advance();
            }
            object2 = kNNHeap.toKNNList();
            meanVariance.reset();
            DoubleDBIDListIter doubleDBIDListIter = object2.iter();
            DoubleDBIDListIter doubleDBIDListIter2 = object2.iter();
            while (doubleDBIDListIter.valid()) {
                d = doubleDBIDListIter.doubleValue();
                d2 = kernelMatrix.getSimilarity((DBIDRef)object, doubleDBIDListIter);
                if (d > 0.0) {
                    doubleDBIDListIter2.seek(doubleDBIDListIter.getOffset() + 1);
                    while (doubleDBIDListIter2.valid()) {
                        double d5 = doubleDBIDListIter2.doubleValue();
                        double d6 = kernelMatrix.getSimilarity((DBIDRef)object, doubleDBIDListIter2);
                        if (d5 > 0.0) {
                            double d7 = kernelMatrix.getSimilarity(doubleDBIDListIter, doubleDBIDListIter2);
                            double d8 = d7 - d2 - d6 + d3;
                            double d9 = 1.0 / (d * d5);
                            meanVariance.put(d8 * d9, Math.sqrt(d9));
                        }
                        doubleDBIDListIter2.advance();
                    }
                }
                doubleDBIDListIter.advance();
            }
            d = meanVariance.getNaiveVariance();
            doubleMinMax.put(d);
            writableDoubleDataStore.putDouble((DBIDRef)object, d);
            object.advance();
        }
        object = new MaterializedDoubleRelation("Angle-Based Outlier Degree", "abod-outlier", writableDoubleDataStore, relation.getDBIDs());
        InvertedOutlierScoreMeta invertedOutlierScoreMeta = new InvertedOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY);
        return new OutlierResult(invertedOutlierScoreMeta, (DoubleRelation)object);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends ABOD.Parameterizer<V> {
        public static final OptionID K_ID = new OptionID("fastabod.k", "Number of nearest neighbors to use for ABOD.");
        protected int k;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)new GreaterEqualConstraint(3));
            if (parameterization.grab(intParameter)) {
                this.k = intParameter.intValue();
            }
        }

        @Override
        protected FastABOD<V> makeInstance() {
            return new FastABOD(this.kernelFunction, this.k);
        }
    }
}

