/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.clustering;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeansLloyd;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.ModelUtil;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

public class KMeansOutlierDetection<O extends NumberVector>
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(KMeansOutlierDetection.class);
    KMeans<O, ?> clusterer;

    public KMeansOutlierDetection(KMeans<O, ?> kMeans) {
        this.clusterer = kMeans;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        DistanceFunction distanceFunction = this.clusterer.getDistanceFunction();
        DistanceQuery<DBIDIter> distanceQuery = database.getDistanceQuery(relation, distanceFunction, new Object[0]);
        Clustering<?> clustering = this.clusterer.run(database, relation);
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 30);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        NumberVector.Factory factory = (NumberVector.Factory)RelationUtil.assumeVectorField(relation).getFactory();
        List<Cluster<?>> list = clustering.getAllClusters();
        for (Cluster<?> object2 : list) {
            Object v = factory.newNumberVector(ModelUtil.getPrototype(object2.getModel(), relation));
            DBIDIter dBIDIter = object2.getIDs().iter();
            while (dBIDIter.valid()) {
                double d = distanceQuery.distance((DBIDIter)v, dBIDIter);
                writableDoubleDataStore.put((DBIDRef)dBIDIter, d);
                doubleMinMax.put(d);
                dBIDIter.advance();
            }
        }
        MaterializedDoubleRelation materializedDoubleRelation = new MaterializedDoubleRelation("KMeans outlier scores", "kmeans-outlier", writableDoubleDataStore, relation.getDBIDs());
        BasicOutlierScoreMeta basicOutlierScoreMeta = new BasicOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        return new OutlierResult(basicOutlierScoreMeta, materializedDoubleRelation);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.clusterer.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID CLUSTERING_ID = new OptionID("kmeans.algorithm", "Clustering algorithm to use for detecting outliers.");
        KMeans<O, ?> clusterer;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(CLUSTERING_ID, (Class<?>)KMeans.class, KMeansLloyd.class);
            if (parameterization.grab(objectParameter)) {
                this.clusterer = (KMeans)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected KMeansOutlierDetection<O> makeInstance() {
            return new KMeansOutlierDetection<O>(this.clusterer);
        }
    }
}

