/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.distance;

import de.lmu.ifi.dbs.elki.algorithm.outlier.distance.AbstractDBOutlier;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

@Title(value="DBOD: Distance Based Outlier Detection")
@Description(value="If the D-neighborhood of an object contains only very few objects (less than (1-p) percent of the data) this object is flagged as an outlier")
@Reference(authors="E.M. Knorr, R. T. Ng", title="Algorithms for Mining Distance-Based Outliers in Large Datasets", booktitle="Procs Int. Conf. on Very Large Databases (VLDB'98), New York, USA, 1998")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.DBOutlierDetection"})
public class DBOutlierDetection<O>
extends AbstractDBOutlier<O> {
    private static final Logging LOG = Logging.getLogger(DBOutlierDetection.class);
    private double p;

    public DBOutlierDetection(DistanceFunction<? super O> distanceFunction, double d, double d2) {
        super(distanceFunction, d);
        this.p = d2;
    }

    @Override
    protected DoubleDataStore computeOutlierScores(Database database, Relation<O> relation, double d) {
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> kNNQuery = database.getKNNQuery(distanceQuery, "optimized");
        int n = (int)((double)distanceQuery.getRelation().size() * (1.0 - this.p));
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(distanceQuery.getRelation().getDBIDs(), 4);
        if (LOG.isVerbose()) {
            LOG.verbose("computing outlier flag");
        }
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("DBOutlier for objects", distanceQuery.getRelation().size(), LOG) : null;
        int n2 = 0;
        if (kNNQuery != null) {
            DBIDIter dBIDIter = distanceQuery.getRelation().iterDBIDs();
            while (dBIDIter.valid()) {
                ++n2;
                KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, n);
                if (LOG.isDebugging()) {
                    LOG.debugFine("distance to mth nearest neighbour" + kNNList.toString());
                }
                if (kNNList.get(Math.min(n, kNNList.size()) - 1).doubleValue() <= d) {
                    writableDoubleDataStore.putDouble(dBIDIter, 1.0);
                } else {
                    writableDoubleDataStore.putDouble(dBIDIter, 0.0);
                }
                dBIDIter.advance();
            }
            if (finiteProgress != null) {
                finiteProgress.setProcessed(n2, LOG);
            }
        } else {
            DBIDIter dBIDIter = distanceQuery.getRelation().iterDBIDs();
            while (dBIDIter.valid()) {
                ++n2;
                int n3 = 0;
                DBIDIter dBIDIter2 = distanceQuery.getRelation().iterDBIDs();
                while (dBIDIter2.valid() && n3 < n) {
                    double d2 = distanceQuery.distance((DBIDRef)dBIDIter, (DBIDRef)dBIDIter2);
                    if (d2 <= d) {
                        ++n3;
                    }
                    dBIDIter2.advance();
                }
                writableDoubleDataStore.putDouble(dBIDIter, n3 < n ? 1.0 : 0.0);
                dBIDIter.advance();
            }
            if (finiteProgress != null) {
                finiteProgress.setProcessed(n2, LOG);
            }
        }
        LOG.ensureCompleted(finiteProgress);
        return writableDoubleDataStore;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDBOutlier.Parameterizer<O> {
        public static final OptionID P_ID = new OptionID("dbod.p", "minimum fraction of objects that must be outside the D-neighborhood of an outlier");
        protected double p = 0.0;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(P_ID);
            if (parameterization.grab(doubleParameter)) {
                this.p = (Double)doubleParameter.getValue();
            }
        }

        @Override
        protected DBOutlierDetection<O> makeInstance() {
            return new DBOutlierDetection(this.distanceFunction, this.d, this.p);
        }
    }
}

