/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.CombinedTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.AbstractProgress;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.GaussianKernelDensityFunction;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.KernelDensityFunction;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.ProbabilisticOutlierScore;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.LessEqualGlobalConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="Erich Schubert, Arthur Zimek, Hans-Peter Kriegel", title="Generalized Outlier Detection with Flexible Kernel Density Estimates", booktitle="Proc. 14th SIAM International Conference on Data Mining (SDM), Philadelphia, PA, 2014", url="http://dx.doi.org/10.1137/1.9781611973440.63")
public class KDEOS<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(KDEOS.class);
    KernelDensityFunction kernel;
    int kmin;
    int kmax;
    double scale;
    double minBandwidth = 1.0E-6;
    int idim = -1;
    static final double CUTOFF = 1.0E-20;

    public KDEOS(DistanceFunction<? super O> distanceFunction, int n, int n2, KernelDensityFunction kernelDensityFunction, double d, double d2, int n3) {
        super(distanceFunction);
        this.kmin = n;
        this.kmax = n2;
        this.kernel = kernelDensityFunction;
        this.minBandwidth = d;
        this.scale = d2;
        this.idim = n3;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        DBIDs dBIDs = relation.getDBIDs();
        LOG.verbose("Running kNN preprocessor.");
        KNNQuery<O> kNNQuery = DatabaseUtil.precomputedKNNQuery(database, relation, this.getDistanceFunction(), this.kmax + 1);
        WritableDataStore<double[]> writableDataStore = DataStoreUtil.makeStorage(dBIDs, 3, double[].class);
        this.estimateDensities(relation, kNNQuery, dBIDs, writableDataStore);
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 30);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        this.computeOutlierScores(kNNQuery, dBIDs, writableDataStore, writableDoubleDataStore, doubleMinMax);
        MaterializedDoubleRelation materializedDoubleRelation = new MaterializedDoubleRelation("Kernel Density Estimation Outlier Scores", "kdeos-outlier", writableDoubleDataStore, dBIDs);
        ProbabilisticOutlierScore probabilisticOutlierScore = new ProbabilisticOutlierScore(doubleMinMax.getMin(), doubleMinMax.getMax());
        return new OutlierResult(probabilisticOutlierScore, materializedDoubleRelation);
    }

    protected void estimateDensities(Relation<O> relation, KNNQuery<O> kNNQuery, DBIDs dBIDs, WritableDataStore<double[]> writableDataStore) {
        int n = this.dimensionality(relation);
        int n2 = this.kmax + 1 - this.kmin;
        Object object = dBIDs.iter();
        while (object.valid()) {
            writableDataStore.put((DBIDRef)object, new double[n2]);
            object.advance();
        }
        object = LOG.isVerbose() ? new FiniteProgress("Computing densities", dBIDs.size(), LOG) : null;
        double d = this.minBandwidth > 0.0 ? 1.0 / (this.minBandwidth * this.scale) : Double.POSITIVE_INFINITY;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, this.kmax + 1);
            int n3 = 0;
            double d2 = 0.0;
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            for (int i = 1; i <= this.kmax && doubleDBIDListIter.valid(); ++i) {
                d2 += doubleDBIDListIter.doubleValue();
                if (i >= this.kmin) {
                    double d3 = Math.min((double)i / (d2 * this.scale), d);
                    double d4 = MathUtil.powi(d3, n);
                    DoubleDBIDListIter doubleDBIDListIter2 = kNNList.iter();
                    while (doubleDBIDListIter2.valid()) {
                        double d5 = d4 < Double.POSITIVE_INFINITY ? d4 * this.kernel.density(doubleDBIDListIter2.doubleValue() * d3) : (doubleDBIDListIter2.doubleValue() == 0.0 ? 1.0 : 0.0);
                        double[] dArray = (double[])writableDataStore.get(doubleDBIDListIter2);
                        int n4 = n3;
                        dArray[n4] = dArray[n4] + d5;
                        if (d5 < 1.0E-20) break;
                        doubleDBIDListIter2.advance();
                    }
                    ++n3;
                }
                doubleDBIDListIter.advance();
            }
            LOG.incrementProcessed((AbstractProgress)object);
            dBIDIter.advance();
        }
        LOG.ensureCompleted((FiniteProgress)object);
    }

    private int dimensionality(Relation<O> relation) {
        if (this.idim >= 0) {
            return this.idim;
        }
        Relation<O> relation2 = relation;
        int n = RelationUtil.dimensionality(relation2);
        if (n < 1) {
            throw new AbortException("When using KDEOS with non-vectorspace data, the intrinsic dimensionality parameter must be set!");
        }
        return n;
    }

    protected void computeOutlierScores(KNNQuery<O> kNNQuery, DBIDs dBIDs, WritableDataStore<double[]> writableDataStore, WritableDoubleDataStore writableDoubleDataStore, DoubleMinMax doubleMinMax) {
        int n = this.kmax + 1 - this.kmin;
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Computing KDEOS scores", dBIDs.size(), LOG) : null;
        double[][] dArray = new double[n][this.kmax + 5];
        MeanVariance meanVariance = new MeanVariance();
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            double[] dArray2 = (double[])writableDataStore.get(dBIDIter);
            KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, this.kmax);
            if (dArray[0].length < kNNList.size()) {
                dArray = new double[n][kNNList.size() + 5];
            }
            int n2 = 0;
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            while (doubleDBIDListIter.valid()) {
                double[] dArray3 = (double[])writableDataStore.get(doubleDBIDListIter);
                for (int i = 0; i < n; ++i) {
                    dArray[i][n2] = dArray3[i];
                }
                doubleDBIDListIter.advance();
                ++n2;
            }
            assert (n2 == kNNList.size());
            double d = 0.0;
            for (int i = 0; i < n; ++i) {
                meanVariance.reset();
                for (int j = 0; j < kNNList.size(); ++j) {
                    meanVariance.put(dArray[i][j]);
                }
                double d2 = meanVariance.getMean();
                double d3 = meanVariance.getSampleStddev();
                if (!(d3 > 0.0)) continue;
                d += (d2 - dArray2[i]) / d3;
            }
            d /= (double)n;
            d = NormalDistribution.standardNormalCDF(d);
            doubleMinMax.put(d);
            writableDoubleDataStore.put((DBIDRef)dBIDIter, d);
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        TypeInformation typeInformation = this.getDistanceFunction().getInputTypeRestriction();
        if (this.idim < 0) {
            typeInformation = new CombinedTypeInformation(TypeUtil.NUMBER_VECTOR_FIELD, typeInformation);
        }
        return TypeUtil.array(typeInformation);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID KERNEL_ID = new OptionID("kdeos.kernel", "Kernel density function to use.");
        public static final OptionID KERNEL_MIN_ID = new OptionID("kdeos.kernel.minbw", "Minimum bandwidth for kernel density estimation.");
        public static final OptionID KERNEL_SCALE_ID = new OptionID("kdeos.kernel.scale", "Scaling factor for the kernel function.");
        public static final OptionID KMIN_ID = new OptionID("kdeos.k.min", "Minimum value of k to analyze.");
        public static final OptionID KMAX_ID = new OptionID("kdeos.k.max", "Maximum value of k to analyze.");
        public static final OptionID IDIM_ID = new OptionID("kdeos.idim", "Intrinsic dimensionality of this data set. Use -1 for using the true data dimensionality, but values such as 0-2 often offer better performance.");
        KernelDensityFunction kernel;
        int kmin;
        int kmax;
        double scale;
        double minBandwidth = 0.0;
        int idim = -1;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            IntParameter intParameter;
            DoubleParameter doubleParameter;
            IntParameter intParameter2;
            IntParameter intParameter3;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(KERNEL_ID, (Class<?>)KernelDensityFunction.class, GaussianKernelDensityFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.kernel = (KernelDensityFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(intParameter3 = (IntParameter)new IntParameter(KMIN_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.kmin = intParameter3.intValue();
            }
            if (parameterization.grab(intParameter2 = (IntParameter)new IntParameter(KMAX_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.kmax = intParameter2.intValue();
            }
            parameterization.checkConstraint(new LessEqualGlobalConstraint<Integer>(intParameter3, intParameter2));
            DoubleParameter doubleParameter2 = (DoubleParameter)((DoubleParameter)new DoubleParameter(KERNEL_SCALE_ID).addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).setDefaultValue((Object)0.5);
            if (parameterization.grab(doubleParameter2)) {
                this.scale = doubleParameter2.doubleValue() * (this.kernel != null ? this.kernel.canonicalBandwidth() : 1.0);
            }
            if (parameterization.grab(doubleParameter = (DoubleParameter)((DoubleParameter)new DoubleParameter(KERNEL_MIN_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).setOptional(true))) {
                this.minBandwidth = doubleParameter.doubleValue();
            }
            if (parameterization.grab(intParameter = new IntParameter(IDIM_ID, -1))) {
                this.idim = intParameter.intValue();
            }
        }

        @Override
        protected KDEOS<O> makeInstance() {
            return new KDEOS(this.distanceFunction, this.kmin, this.kmax, this.kernel, this.minBandwidth, this.scale, this.idim);
        }
    }
}

