/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof.parallel;

import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.parallel.Executor;
import de.lmu.ifi.dbs.elki.parallel.processor.AbstractDoubleProcessor;
import de.lmu.ifi.dbs.elki.parallel.variables.SharedDouble;

public class LOFProcessor
extends AbstractDoubleProcessor {
    private DataStore<? extends KNNList> knns;
    private DoubleDataStore lrds;
    private boolean noself;

    public LOFProcessor(DataStore<? extends KNNList> dataStore, DoubleDataStore doubleDataStore, boolean bl) {
        this.knns = dataStore;
        this.lrds = doubleDataStore;
        this.noself = bl;
    }

    @Override
    public Instance instantiate(Executor executor) {
        return new Instance(executor.getInstance(this.output));
    }

    private class Instance
    extends AbstractDoubleProcessor.Instance {
        protected Instance(SharedDouble.Instance instance) {
            super(instance);
        }

        @Override
        public void map(DBIDRef dBIDRef) {
            double d = LOFProcessor.this.lrds.doubleValue(dBIDRef);
            if (Double.isInfinite(d)) {
                this.output.set(1.0);
                return;
            }
            KNNList kNNList = (KNNList)LOFProcessor.this.knns.get(dBIDRef);
            double d2 = 0.0;
            int n = 0;
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            while (doubleDBIDListIter.valid()) {
                if (!LOFProcessor.this.noself || !DBIDUtil.equal(doubleDBIDListIter, dBIDRef)) {
                    ++n;
                    if (Double.isInfinite(d2 += LOFProcessor.this.lrds.doubleValue(doubleDBIDListIter))) break;
                }
                doubleDBIDListIter.advance();
            }
            d2 = n > 0 ? d2 / (double)n : 0.0;
            this.output.set(d2 / d);
        }
    }
}

