/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.AbstractNeighborhoodOutlier;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="Median Algorithm for Spatial Outlier Detection")
@Reference(authors="C.-T. Lu and D. Chen and Y. Kou", title="Algorithms for Spatial Outlier Detection", booktitle="Proc. 3rd IEEE International Conference on Data Mining", url="http://dx.doi.org/10.1109/ICDM.2003.1250986")
public class CTLuMedianAlgorithm<N>
extends AbstractNeighborhoodOutlier<N> {
    private static final Logging LOG = Logging.getLogger(CTLuMedianAlgorithm.class);

    public CTLuMedianAlgorithm(NeighborSetPredicate.Factory<N> factory) {
        super(factory);
    }

    public OutlierResult run(Database database, Relation<N> relation, Relation<? extends NumberVector> relation2) {
        double d;
        NeighborSetPredicate neighborSetPredicate = this.getNeighborSetPredicateFactory().instantiate(database, relation);
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation2.getDBIDs(), 4);
        MeanVariance meanVariance = new MeanVariance();
        DBIDIter dBIDIter = relation2.iterDBIDs();
        while (dBIDIter.valid()) {
            DBIDs dBIDs = neighborSetPredicate.getNeighborDBIDs(dBIDIter);
            double[] dArray = new double[dBIDs.size()];
            int n = 0;
            DBIDIter dBIDIter2 = dBIDs.iter();
            while (dBIDIter2.valid()) {
                if (!DBIDUtil.equal(dBIDIter, dBIDIter2)) {
                    dArray[n] = relation2.get(dBIDIter2).doubleValue(0);
                    ++n;
                }
                dBIDIter2.advance();
            }
            d = n > 0 ? QuickSelect.median(dArray, 0, n) : relation2.get(dBIDIter).doubleValue(0);
            double d2 = relation2.get(dBIDIter).doubleValue(0) - d;
            writableDoubleDataStore.putDouble(dBIDIter, d2);
            meanVariance.put(d2);
            dBIDIter.advance();
        }
        double d3 = meanVariance.getMean();
        d = meanVariance.getNaiveStddev();
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        Object object = relation2.iterDBIDs();
        while (object.valid()) {
            double d4 = Math.abs((writableDoubleDataStore.doubleValue((DBIDRef)object) - d3) / d);
            doubleMinMax.put(d4);
            writableDoubleDataStore.putDouble((DBIDRef)object, d4);
            object.advance();
        }
        object = new MaterializedDoubleRelation("MO", "Median-outlier", writableDoubleDataStore, relation2.getDBIDs());
        BasicOutlierScoreMeta basicOutlierScoreMeta = new BasicOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        OutlierResult outlierResult = new OutlierResult(basicOutlierScoreMeta, (DoubleRelation)object);
        outlierResult.addChildResult(neighborSetPredicate);
        return outlierResult;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getNeighborSetPredicateFactory().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD_1D);
    }

    public static class Parameterizer<N>
    extends AbstractNeighborhoodOutlier.Parameterizer<N> {
        @Override
        protected CTLuMedianAlgorithm<N> makeInstance() {
            return new CTLuMedianAlgorithm(this.npredf);
        }
    }
}

