/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.AbstractNeighborhoodOutlier;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.CovarianceMatrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.result.AbstractHierarchicalResult;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="Chang-Tien Lu and Dechang Chen and Yufeng Kou", title="Detecting Spatial Outliers with Multiple Attributes", booktitle="Proc. 15th IEEE International Conference on Tools with Artificial Intelligence, 2003", url="http://dx.doi.org/10.1109/TAI.2003.1250179")
public class CTLuMedianMultipleAttributes<N, O extends NumberVector>
extends AbstractNeighborhoodOutlier<N> {
    private static final Logging LOG = Logging.getLogger(CTLuMedianMultipleAttributes.class);

    public CTLuMedianMultipleAttributes(NeighborSetPredicate.Factory<N> factory) {
        super(factory);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public OutlierResult run(Database database, Relation<N> relation, Relation<O> relation2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n = RelationUtil.dimensionality(relation2);
        if (LOG.isDebugging()) {
            LOG.debug("Dimensionality: " + n);
        }
        NeighborSetPredicate neighborSetPredicate = this.getNeighborSetPredicateFactory().instantiate(database, relation);
        CovarianceMatrix covarianceMatrix = new CovarianceMatrix(n);
        WritableDataStore<Vector> writableDataStore = DataStoreUtil.makeStorage(relation2.getDBIDs(), 1, Vector.class);
        Object object6 = relation2.iterDBIDs();
        while (object6.valid()) {
            object5 = (NumberVector)relation2.get((DBIDRef)object6);
            object4 = neighborSetPredicate.getNeighborDBIDs((DBIDRef)object6);
            object3 = new double[n][object4.size()];
            int n2 = 0;
            object2 = object4.iter();
            while (object2.valid()) {
                NumberVector numberVector = (NumberVector)relation2.get((DBIDRef)object2);
                for (int i = 0; i < n; ++i) {
                    object3[i][n2] = numberVector.doubleValue(i);
                }
                ++n2;
                object2.advance();
            }
            object2 = new double[n];
            for (int i = 0; i < n; ++i) {
                object2[i] = QuickSelect.median((double[])object3[i]);
            }
            object = new Vector((double[])object2);
            object3 = object5.getColumnVector().minusEquals((Vector)object);
            writableDataStore.put((DBIDRef)object6, (Vector)object3);
            covarianceMatrix.put((Vector)object3);
            object6.advance();
        }
        object6 = covarianceMatrix.getMeanVector();
        object5 = covarianceMatrix.destroyToSampleMatrix().inverse();
        object4 = new DoubleMinMax();
        object = DataStoreUtil.makeDoubleStorage(relation2.getDBIDs(), 4);
        object3 = relation2.iterDBIDs();
        while (object3.valid()) {
            double d = MathUtil.mahalanobisDistance((Matrix)object5, (Vector)writableDataStore.get((DBIDRef)object3), (Vector)object6);
            ((DoubleMinMax)object4).put(d);
            object.putDouble((DBIDRef)object3, d);
            object3.advance();
        }
        object3 = new MaterializedDoubleRelation("Median multiple attributes outlier", "median-outlier", (DoubleDataStore)object, relation2.getDBIDs());
        BasicOutlierScoreMeta basicOutlierScoreMeta = new BasicOutlierScoreMeta(((DoubleMinMax)object4).getMin(), ((DoubleMinMax)object4).getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        object2 = new OutlierResult(basicOutlierScoreMeta, (DoubleRelation)object3);
        ((AbstractHierarchicalResult)object2).addChildResult(neighborSetPredicate);
        return object2;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getNeighborSetPredicateFactory().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD);
    }

    public static class Parameterizer<N, O extends NumberVector>
    extends AbstractNeighborhoodOutlier.Parameterizer<N> {
        @Override
        protected CTLuMedianMultipleAttributes<N, O> makeInstance() {
            return new CTLuMedianMultipleAttributes(this.npredf);
        }
    }
}

