/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.AbstractNeighborhoodOutlier;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="Moran Scatterplot Outlier")
@Description(value="Spatial Outlier detection based on the standardized deviation from the local means.")
@Reference(authors="S. Shekhar and C.-T. Lu and P. Zhang", title="A Unified Approach to Detecting Spatial Outliers", booktitle="GeoInformatica 7-2, 2003", url="http://dx.doi.org/10.1023/A:1023455925009")
public class CTLuMoranScatterplotOutlier<N>
extends AbstractNeighborhoodOutlier<N> {
    private static final Logging LOG = Logging.getLogger(CTLuMoranScatterplotOutlier.class);

    public CTLuMoranScatterplotOutlier(NeighborSetPredicate.Factory<N> factory) {
        super(factory);
    }

    public OutlierResult run(Database database, Relation<N> relation, Relation<? extends NumberVector> relation2) {
        NeighborSetPredicate neighborSetPredicate = this.getNeighborSetPredicateFactory().instantiate(database, relation);
        MeanVariance meanVariance = new MeanVariance();
        Object object = relation2.iterDBIDs();
        while (object.valid()) {
            meanVariance.put(relation2.get((DBIDRef)object).doubleValue(0));
            object.advance();
        }
        object = new DoubleMinMax();
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation2.getDBIDs(), 4);
        Object object2 = relation2.iterDBIDs();
        while (object2.valid()) {
            double d = (relation2.get((DBIDRef)object2).doubleValue(0) - meanVariance.getMean()) / meanVariance.getNaiveStddev();
            Mean mean = new Mean();
            DBIDIter dBIDIter = neighborSetPredicate.getNeighborDBIDs((DBIDRef)object2).iter();
            while (dBIDIter.valid()) {
                if (!DBIDUtil.equal((DBIDRef)object2, dBIDIter)) {
                    mean.put((relation2.get(dBIDIter).doubleValue(0) - meanVariance.getMean()) / meanVariance.getNaiveStddev());
                }
                dBIDIter.advance();
            }
            double d2 = mean.getCount() > 0.0 ? mean.getMean() : d;
            double d3 = Math.max(-d * d2, 0.0);
            ((DoubleMinMax)object).put(d3);
            writableDoubleDataStore.putDouble((DBIDRef)object2, d3);
            object2.advance();
        }
        object2 = new MaterializedDoubleRelation("MoranOutlier", "Moran Scatterplot Outlier", writableDoubleDataStore, relation2.getDBIDs());
        BasicOutlierScoreMeta basicOutlierScoreMeta = new BasicOutlierScoreMeta(((DoubleMinMax)object).getMin(), ((DoubleMinMax)object).getMax(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        OutlierResult outlierResult = new OutlierResult(basicOutlierScoreMeta, (DoubleRelation)object2);
        outlierResult.addChildResult(neighborSetPredicate);
        return outlierResult;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getNeighborSetPredicateFactory().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD_1D);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<N>
    extends AbstractNeighborhoodOutlier.Parameterizer<N> {
        @Override
        protected CTLuMoranScatterplotOutlier<N> makeInstance() {
            return new CTLuMoranScatterplotOutlier(this.npredf);
        }
    }
}

