/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.subspace;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.SubspaceClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.SubspaceModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="OutRank: ranking outliers in high dimensional data")
@Description(value="Ranking outliers in high dimensional data - score 1")
@Reference(authors="Emmanuel M\u00fcller, Ira Assent, Uwe Steinhausen, Thomas Seidl", title="OutRank: ranking outliers in high dimensional data", booktitle="Proc. 24th Int. Conf. on Data Engineering (ICDE) Workshop on Ranking in Databases (DBRank), Cancun, Mexico", url="http://dx.doi.org/10.1109/ICDEW.2008.4498387")
public class OutRankS1
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(OutRankS1.class);
    protected SubspaceClusteringAlgorithm<? extends SubspaceModel> clusteralg;
    double alpha;

    public OutRankS1(SubspaceClusteringAlgorithm<? extends SubspaceModel> subspaceClusteringAlgorithm, double d) {
        this.clusteralg = subspaceClusteringAlgorithm;
        this.alpha = d;
    }

    @Override
    public OutlierResult run(Database database) {
        DBIDs dBIDs = database.getRelation(TypeUtil.ANY, new Object[0]).getDBIDs();
        Object c = this.clusteralg.run(database);
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 2);
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            writableDoubleDataStore.putDouble(dBIDIter, 0.0);
            dBIDIter.advance();
        }
        int n = 0;
        int n2 = 0;
        for (Cluster object22 : ((Clustering)c).getAllClusters()) {
            n2 = Math.max(n2, object22.size());
            n = Math.max(n, BitsUtil.cardinality(((SubspaceModel)object22.getModel()).getDimensions()));
        }
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        for (Cluster cluster : ((Clustering)c).getAllClusters()) {
            double d = (double)cluster.size() / (double)n2;
            double d2 = (double)BitsUtil.cardinality(((SubspaceModel)cluster.getModel()).getDimensions()) / (double)n;
            DBIDIter dBIDIter2 = cluster.getIDs().iter();
            while (dBIDIter2.valid()) {
                double d3 = writableDoubleDataStore.doubleValue(dBIDIter2) + this.alpha * d + (1.0 - this.alpha) * d2;
                writableDoubleDataStore.putDouble(dBIDIter2, d3);
                doubleMinMax.put(d3);
                dBIDIter2.advance();
            }
        }
        MaterializedDoubleRelation materializedDoubleRelation = new MaterializedDoubleRelation("OutRank-S1", "OUTRANK_S1", writableDoubleDataStore, dBIDs);
        InvertedOutlierScoreMeta invertedOutlierScoreMeta = new InvertedOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY);
        OutlierResult outlierResult = new OutlierResult(invertedOutlierScoreMeta, materializedDoubleRelation);
        outlierResult.addChildResult((Result)c);
        return outlierResult;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return this.clusteralg.getInputTypeRestriction();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID ALGORITHM_ID = new OptionID("outrank.algorithm", "Subspace clustering algorithm to use.");
        public static final OptionID ALPHA_ID = new OptionID("outrank.s1.alpha", "Alpha parameter for S1 score.");
        protected SubspaceClusteringAlgorithm<? extends SubspaceModel> algorithm = null;
        protected double alpha = 0.25;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(ALGORITHM_ID, SubspaceClusteringAlgorithm.class);
            if (parameterization.grab(objectParameter)) {
                this.algorithm = (SubspaceClusteringAlgorithm)objectParameter.instantiateClass(parameterization);
            }
            DoubleParameter doubleParameter = new DoubleParameter(ALPHA_ID, 0.25);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.alpha = doubleParameter.doubleValue();
            }
        }

        @Override
        protected OutRankS1 makeInstance() {
            return new OutRankS1(this.algorithm, this.alpha);
        }
    }
}

