/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.experiments;

import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.AbstractIntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.AggregatedHillEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.GEDEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.HillEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.IntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.LMomentsEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.MOMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.PWM2Estimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.PWMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.RVEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.ZipfEstimator;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.exceptions.UnableToComplyException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;

public class EvaluateIntrinsicDimensionalityEstimators
extends AbstractApplication {
    int startk = 3;
    int maxk = 10;
    int samples = 1000;
    int dim = 5;
    Aggregate agg;
    OutputFormat format;
    RandomFactory rnd;

    public EvaluateIntrinsicDimensionalityEstimators(int n, int n2, int n3, int n4, Aggregate aggregate, OutputFormat outputFormat, RandomFactory randomFactory) {
        this.startk = n;
        this.maxk = n2;
        this.samples = n3;
        this.dim = n4;
        this.agg = aggregate;
        this.format = outputFormat;
        this.rnd = randomFactory;
    }

    @Override
    public void run() throws UnableToComplyException {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<AbstractIntrinsicDimensionalityEstimator> arrayList2 = new ArrayList<AbstractIntrinsicDimensionalityEstimator>();
        arrayList.add("Hill");
        arrayList2.add(HillEstimator.STATIC);
        arrayList.add("MoM");
        arrayList2.add(MOMEstimator.STATIC);
        arrayList.add("RV");
        arrayList2.add(RVEstimator.STATIC);
        arrayList.add("AggHi");
        arrayList2.add(AggregatedHillEstimator.STATIC);
        arrayList.add("Zipf");
        arrayList2.add(ZipfEstimator.STATIC);
        arrayList.add("GED");
        arrayList2.add(GEDEstimator.STATIC);
        arrayList.add("LMM");
        arrayList2.add(LMomentsEstimator.STATIC);
        arrayList.add("PWM");
        arrayList2.add(PWMEstimator.STATIC);
        arrayList.add("PWM2");
        arrayList2.add(PWM2Estimator.STATIC);
        PrintStream printStream = System.out;
        int n2 = (int)Math.ceil(Math.log10(this.maxk + 1));
        switch (this.format) {
            case TABULAR: {
                String string;
                int n3;
                String[] stringArray;
                int n4;
                printStream.append(String.format("%" + n2 + "s", "k"));
                for (n4 = 0; n4 < arrayList2.size(); ++n4) {
                    stringArray = this.agg.description();
                    n = stringArray.length;
                    for (n3 = 0; n3 < n; ++n3) {
                        string = stringArray[n3];
                        printStream.format(Locale.ROOT, " %10s", (String)arrayList.get(n4) + "-" + string);
                    }
                }
                printStream.append(FormatUtil.NEWLINE);
                break;
            }
            case TSV: {
                String string;
                int n3;
                String[] stringArray;
                int n4;
                printStream.append("k");
                for (n4 = 0; n4 < arrayList2.size(); ++n4) {
                    stringArray = this.agg.description();
                    n = stringArray.length;
                    for (n3 = 0; n3 < n; ++n3) {
                        string = stringArray[n3];
                        printStream.append('\t').append((CharSequence)arrayList.get(n4)).append('-').append(string);
                    }
                }
                printStream.append(FormatUtil.NEWLINE);
            }
        }
        double[][] dArray = new double[arrayList2.size()][this.samples];
        block12: for (int i = this.startk; i <= this.maxk; ++i) {
            for (n = 0; n < this.samples; ++n) {
                double[] dArray2 = this.makeSample(i);
                for (int j = 0; j < arrayList2.size(); ++j) {
                    IntrinsicDimensionalityEstimator intrinsicDimensionalityEstimator = (IntrinsicDimensionalityEstimator)arrayList2.get(j);
                    dArray[j][n] = intrinsicDimensionalityEstimator.estimate(dArray2, i);
                }
            }
            switch (this.format) {
                case TABULAR: {
                    printStream.append(String.format("%0" + n2 + "d", i));
                    for (n = 0; n < arrayList2.size(); ++n) {
                        for (double d : this.agg.aggregate(dArray[n])) {
                            printStream.format(Locale.ROOT, " %10f", d);
                        }
                    }
                    printStream.append(FormatUtil.NEWLINE);
                    continue block12;
                }
                case TSV: {
                    printStream.append(FormatUtil.NF.format(i));
                    for (n = 0; n < arrayList2.size(); ++n) {
                        for (double d : this.agg.aggregate(dArray[n])) {
                            printStream.append('\t');
                            printStream.append(FormatUtil.NF.format(d));
                        }
                    }
                    printStream.append(FormatUtil.NEWLINE);
                }
            }
        }
    }

    protected double[] makeSample(int n) {
        Random random = this.rnd.getSingleThreadedRandom();
        double[] dArray = new double[n + 1];
        double d = 1.0 / (double)this.dim;
        for (int i = 0; i <= n; ++i) {
            dArray[i] = Math.pow(random.nextDouble(), d);
        }
        Arrays.sort(dArray);
        return dArray;
    }

    public static void main(String[] stringArray) {
        EvaluateIntrinsicDimensionalityEstimators.runCLIApplication(EvaluateIntrinsicDimensionalityEstimators.class, stringArray);
    }

    public static class Parameterizer
    extends AbstractApplication.Parameterizer {
        public static final OptionID STARTK_ID = new OptionID("mink", "Minimum value of k.");
        public static final OptionID MAXK_ID = new OptionID("maxk", "Maximum value of k.");
        public static final OptionID SAMPLE_ID = new OptionID("sample", "Sample size for averaging.");
        public static final OptionID DIM_ID = new OptionID("dim", "Dimensionality.");
        public static final OptionID SEED_ID = new OptionID("seed", "Random seed.");
        public static final OptionID AGGREGATE_ID = new OptionID("aggregation", "Aggregation method.");
        public static final OptionID FORMAT_ID = new OptionID("output-format", "Output format (ascii, or tab separated).");
        int startk = 3;
        int maxk = 10;
        int samples = 1000;
        int dim = 5;
        Aggregate agg;
        OutputFormat format;
        RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            EnumParameter<OutputFormat> enumParameter;
            EnumParameter<Aggregate> enumParameter2;
            IntParameter intParameter;
            RandomParameter randomParameter;
            IntParameter intParameter2;
            IntParameter intParameter3;
            super.makeOptions(parameterization);
            IntParameter intParameter4 = new IntParameter(STARTK_ID, 3);
            if (parameterization.grab(intParameter4)) {
                this.startk = intParameter4.intValue();
            }
            if (parameterization.grab(intParameter3 = new IntParameter(MAXK_ID, 20))) {
                this.maxk = intParameter3.intValue();
            }
            if (parameterization.grab(intParameter2 = new IntParameter(SAMPLE_ID, 1000))) {
                this.samples = intParameter2.intValue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(SEED_ID))) {
                this.rnd = (RandomFactory)randomParameter.getValue();
            }
            if (parameterization.grab(intParameter = new IntParameter(DIM_ID))) {
                this.dim = intParameter.intValue();
            }
            if (parameterization.grab(enumParameter2 = new EnumParameter<Aggregate>(AGGREGATE_ID, Aggregate.class, Aggregate.MED_MAD))) {
                this.agg = (Aggregate)((Object)enumParameter2.getValue());
            }
            if (parameterization.grab(enumParameter = new EnumParameter<OutputFormat>(FORMAT_ID, OutputFormat.class, OutputFormat.TABULAR))) {
                this.format = (OutputFormat)((Object)enumParameter.getValue());
            }
        }

        @Override
        protected EvaluateIntrinsicDimensionalityEstimators makeInstance() {
            return new EvaluateIntrinsicDimensionalityEstimators(this.startk, this.maxk, this.samples, this.dim, this.agg, this.format, this.rnd);
        }
    }

    public static enum Aggregate {
        MEAN{

            @Override
            double[] aggregate(double[] dArray) {
                double d = 0.0;
                for (double d2 : dArray) {
                    d += d2;
                }
                return new double[]{d / (double)dArray.length};
            }

            @Override
            String[] description() {
                return new String[]{"Mean"};
            }
        }
        ,
        MEAN_STDDEV{

            @Override
            double[] aggregate(double[] dArray) {
                double d = 0.0;
                for (double d2 : dArray) {
                    d += d2;
                }
                d /= (double)dArray.length;
                double d3 = 0.0;
                for (double d4 : dArray) {
                    double d5 = d4 - d;
                    d3 += d5 * d5;
                }
                return new double[]{d, Math.sqrt(d3 /= (double)dArray.length)};
            }

            @Override
            String[] description() {
                return new String[]{"Mean", "Stddev"};
            }
        }
        ,
        MEAN_STDDEV_MIN_MAX{

            @Override
            double[] aggregate(double[] dArray) {
                double d = 0.0;
                double d2 = Double.POSITIVE_INFINITY;
                double d3 = Double.NEGATIVE_INFINITY;
                for (double d4 : dArray) {
                    d += d4;
                    d2 = d4 < d2 ? d4 : d2;
                    d3 = d4 > d3 ? d4 : d3;
                }
                d /= (double)dArray.length;
                double d5 = 0.0;
                for (double d6 : dArray) {
                    double d7 = d6 - d;
                    d5 += d7 * d7;
                }
                return new double[]{d, Math.sqrt(d5 /= (double)dArray.length), d2, d3};
            }

            @Override
            String[] description() {
                return new String[]{"Mean", "Stddev", "Min", "Max"};
            }
        }
        ,
        HMEAN{

            @Override
            double[] aggregate(double[] dArray) {
                double d = 0.0;
                for (double d2 : dArray) {
                    d += 1.0 / d2;
                }
                return new double[]{(double)dArray.length / d};
            }

            @Override
            String[] description() {
                return new String[]{"HMean"};
            }
        }
        ,
        MEDIAN{

            @Override
            double[] aggregate(double[] dArray) {
                double d = QuickSelect.median(dArray);
                return new double[]{d};
            }

            @Override
            String[] description() {
                return new String[]{"Median"};
            }
        }
        ,
        MED_MAD{

            @Override
            double[] aggregate(double[] dArray) {
                double d = QuickSelect.median(dArray);
                double[] dArray2 = new double[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray2[i] = Math.abs(dArray[i] - d);
                }
                double d2 = QuickSelect.median(dArray2);
                return new double[]{d, d2};
            }

            @Override
            String[] description() {
                return new String[]{"Med", "Mad"};
            }
        }
        ,
        MED_MAD_MIN_MAX{

            @Override
            double[] aggregate(double[] dArray) {
                double d = QuickSelect.median(dArray);
                double[] dArray2 = new double[dArray.length];
                double d2 = d;
                double d3 = d;
                for (int i = 0; i < dArray.length; ++i) {
                    double d4 = dArray[i];
                    d2 = d4 < d2 ? d4 : d2;
                    d3 = d4 > d3 ? d4 : d3;
                    dArray2[i] = Math.abs(d4 - d);
                }
                double d5 = QuickSelect.median(dArray2);
                return new double[]{d, d5, d2, d3};
            }

            @Override
            String[] description() {
                return new String[]{"Med", "Mad", "Min", "Max"};
            }
        }
        ,
        QUANTILES{

            @Override
            double[] aggregate(double[] dArray) {
                double[] dArray2 = new double[]{0.0, 0.1, 0.25, 0.5, 0.75, 0.9, 1.0};
                int n = dArray.length;
                Arrays.sort(dArray);
                double[] dArray3 = new double[dArray2.length];
                for (int i = 0; i < dArray2.length; ++i) {
                    double d = (double)(n - 1) * dArray2[i];
                    int n2 = (int)Math.floor(d);
                    double d2 = d - (double)n2;
                    dArray3[i] = d2 < Double.MIN_NORMAL ? dArray[n2] : dArray[n2] + (dArray[n2 + 1] - dArray[n2]) * d2;
                }
                return dArray3;
            }

            @Override
            String[] description() {
                return new String[]{"Min", "Q10", "Q25", "Med", "Q75", "Q90", "Max"};
            }
        };


        abstract double[] aggregate(double[] var1);

        abstract String[] description();
    }

    public static enum OutputFormat {
        TABULAR,
        TSV;

    }
}

