/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.internal;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceLoader;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceRegistry;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.Parameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class CheckParameterizables {
    private static final Logging LOG = Logging.getLogger(CheckParameterizables.class);
    private List<Class<?>> knownParameterizables;

    public void checkParameterizables() {
        Object object;
        LoggingConfiguration.setVerbose(Logging.Level.VERBOSE);
        this.knownParameterizables = new ArrayList();
        try {
            object = this.getClass().getClassLoader().getResources("META-INF/elki/");
            while (object.hasMoreElements()) {
                URL uRL = object.nextElement();
                if ("file".equals(uRL.getProtocol())) {
                    for (String string : new File(uRL.toURI()).list()) {
                        try {
                            this.knownParameterizables.add(Class.forName(string));
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            LOG.warning("Service file name is not a class name: " + string);
                        }
                    }
                    continue;
                }
                if (!"jar".equals(uRL.getProtocol())) continue;
                JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
                JarFile jarFile = jarURLConnection.getJarFile();
                Throwable throwable = null;
                try {
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    while (enumeration.hasMoreElements()) {
                        String string = enumeration.nextElement().getName();
                        if (string.startsWith("META-INF/elki/")) {
                            string = string.substring("META-INF/elki/".length());
                        } else {
                            if (!string.startsWith(ELKIServiceLoader.FILENAME_PREFIX)) continue;
                            string = string.substring(ELKIServiceLoader.FILENAME_PREFIX.length());
                        }
                        try {
                            this.knownParameterizables.add(Class.forName(string));
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            LOG.warning("Service file name is not a class name: " + string);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jarFile == null) continue;
                    if (throwable != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jarFile.close();
                }
            }
        }
        catch (IOException | URISyntaxException exception) {
            throw new AbortException("Error enumerating service folders.", exception);
        }
        object = Parameterizer.class.getPackage().getName();
        for (Class clazz : ELKIServiceRegistry.findAllImplementations(Object.class, false, false)) {
            if (clazz.getName().startsWith((String)object)) continue;
            try {
                State state = State.NO_CONSTRUCTOR;
                if ((state = this.checkV3Parameterization(clazz, state)) == State.ERROR || (state = this.checkV2Parameterization(clazz, state)) == State.ERROR || (state = this.checkV1Parameterization(clazz, state)) == State.ERROR || (state = this.checkDefaultConstructor(clazz, state)) == State.ERROR) continue;
                int n = this.checkSupertypes(clazz) ? 1 : 0;
                if (state == State.NO_CONSTRUCTOR && n != 0) {
                    LOG.verbose("Class " + clazz.getName() + " implements a parameterizable interface, but doesn't have a public and parameterless constructor!");
                }
                if (state != State.INSTANTIABLE || n != 0) continue;
                LOG.verbose("Class " + clazz.getName() + " has a parameterizer, but there is no service file for any of its interfaces.");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                LOG.verbose("Class discovered but not found: " + clazz.getName() + " (missing: " + noClassDefFoundError.getMessage() + ")");
            }
        }
    }

    private boolean checkSupertypes(Class<?> clazz) {
        for (Class<?> clazz2 : this.knownParameterizables) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    private State checkV1Parameterization(Class<?> clazz, State state) throws NoClassDefFoundError {
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(Parameterization.class);
            if (state == State.INSTANTIABLE) {
                LOG.warning("More than one parameterization method in class " + clazz.getName());
            }
            LOG.warning("V1 constructor found in class: " + clazz.getName());
            if (!Modifier.isPublic(constructor.getModifiers())) {
                LOG.verbose("Constructor for class " + clazz.getName() + " is not public!");
            }
            return State.INSTANTIABLE;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return state;
        }
    }

    private State checkV2Parameterization(Class<?> clazz, State state) throws NoClassDefFoundError {
        try {
            ClassGenericsUtil.getParameterizationFactoryMethod(clazz, Object.class);
            if (state == State.INSTANTIABLE) {
                LOG.warning("More than one parameterization method in class " + clazz.getName());
            }
            LOG.warning("V2 factory method found in class: " + clazz.getName());
            return State.INSTANTIABLE;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return state;
        }
    }

    private State checkV3Parameterization(Class<?> clazz, State state) throws NoClassDefFoundError {
        for (Class<?> clazz2 : clazz.getDeclaredClasses()) {
            if (!AbstractParameterizer.class.isAssignableFrom(clazz2)) continue;
            try {
                Class<AbstractParameterizer> clazz3 = clazz2.asSubclass(AbstractParameterizer.class);
                clazz3.newInstance();
                if (!this.checkParameterizer(clazz, clazz3)) continue;
                if (state == State.INSTANTIABLE) {
                    LOG.warning("More than one parameterization method in class " + clazz.getName());
                }
                state = State.INSTANTIABLE;
            }
            catch (Exception exception) {
                LOG.verbose("Could not run Parameterizer: " + clazz2.getName() + ": " + exception.getMessage());
            }
            catch (Error error) {
                LOG.verbose("Could not run Parameterizer: " + clazz2.getName() + ": " + error.getMessage());
            }
        }
        return state;
    }

    private State checkDefaultConstructor(Class<?> clazz, State state) throws NoClassDefFoundError {
        try {
            clazz.getConstructor(new Class[0]);
            return State.DEFAULT_INSTANTIABLE;
        }
        catch (Exception exception) {
            return state;
        }
    }

    private boolean checkParameterizer(Class<?> clazz, Class<? extends AbstractParameterizer> clazz2) {
        int n = 0;
        try {
            clazz2.getConstructor(new Class[0]);
            Method[] methodArray = clazz2.getDeclaredMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                if (!method.getName().equals("makeInstance")) continue;
                if (method.getParameterTypes().length == 0) {
                    if (clazz.isAssignableFrom(method.getReturnType())) {
                        n = 1;
                        continue;
                    }
                    if (n != 0) continue;
                    n = 2;
                    continue;
                }
                if (n != 0) continue;
                n += 3;
            }
        }
        catch (Exception exception) {
            LOG.warning("No proper Parameterizer.makeInstance for " + clazz.getName() + ": " + exception);
            return false;
        }
        if (n > 1) {
            LOG.warning("No proper Parameterizer.makeInstance for " + clazz.getName() + " found!");
        }
        return n == 1;
    }

    public static void main(String[] stringArray) {
        new CheckParameterizables().checkParameterizables();
    }

    static enum State {
        NO_CONSTRUCTOR,
        INSTANTIABLE,
        DEFAULT_INSTANTIABLE,
        ERROR;

    }
}

