/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.jsmap;

import de.lmu.ifi.dbs.elki.application.jsmap.JSONWebServer;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHandler;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.LessEqualConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

public class JSONResultHandler
implements ResultHandler {
    private JSONWebServer server;
    private int port;

    public JSONResultHandler(int n) {
        this.port = n;
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        if (this.server == null) {
            this.server = new JSONWebServer(this.port, resultHierarchy, result);
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID PORT_ID = new OptionID("json.port", "Port for the JSON web server to listen on.");
        int port = 8080;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(PORT_ID, this.port);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            intParameter.addConstraint((ParameterConstraint)new LessEqualConstraint(65535));
            if (parameterization.grab(intParameter)) {
                this.port = (Integer)intParameter.getValue();
            }
        }

        @Override
        protected JSONResultHandler makeInstance() {
            return new JSONResultHandler(this.port);
        }
    }
}

