/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.model;

import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.model.AbstractModel;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredResult;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriteable;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterStream;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;

public class CorrelationModel<V extends FeatureVector<?>>
extends AbstractModel
implements TextWriteable {
    private PCAFilteredResult pcaresult;
    private V centroid;

    public CorrelationModel(PCAFilteredResult pCAFilteredResult, V v) {
        this.pcaresult = pCAFilteredResult;
        this.centroid = v;
    }

    public PCAFilteredResult getPCAResult() {
        return this.pcaresult;
    }

    public void setPCAResult(PCAFilteredResult pCAFilteredResult) {
        this.pcaresult = pCAFilteredResult;
    }

    public V getCentroid() {
        return this.centroid;
    }

    public void setCentroid(V v) {
        this.centroid = v;
    }

    @Override
    public void writeToText(TextWriterStream textWriterStream, String string) {
        super.writeToText(textWriterStream, string);
        textWriterStream.commentPrintLn("Centroid: " + ((FeatureVector)textWriterStream.normalizationRestore(this.getCentroid())).toString());
        textWriterStream.commentPrintLn("Strong Eigenvectors:");
        String string2 = this.getPCAResult().getStrongEigenvectors().toString();
        while (string2.endsWith("\n")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        textWriterStream.commentPrintLn(string2);
        textWriterStream.commentPrintLn("Weak Eigenvectors:");
        String string3 = this.getPCAResult().getWeakEigenvectors().toString();
        while (string3.endsWith("\n")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        textWriterStream.commentPrintLn(string3);
        textWriterStream.commentPrintLn("Eigenvalues: " + FormatUtil.format(this.getPCAResult().getEigenvalues(), " ", FormatUtil.NF2));
    }
}

