/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.uncertain;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.uncertain.AbstractUncertainObject;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import java.util.Random;

public class UniformContinuousUncertainObject
extends AbstractUncertainObject {
    public static final FeatureVector.Factory<UniformContinuousUncertainObject, ?> FACTORY = new Factory();

    public UniformContinuousUncertainObject(SpatialComparable spatialComparable) {
        this.bounds = spatialComparable;
    }

    @Override
    public DoubleVector getCenterOfMass() {
        int n = this.bounds.getDimensionality();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = (this.bounds.getMin(i) + this.bounds.getMax(i)) * 0.5;
        }
        return new DoubleVector(dArray);
    }

    @Override
    public DoubleVector drawSample(Random random) {
        int n = this.bounds.getDimensionality();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = this.bounds.getMax(i) - this.bounds.getMin(i);
            assert (d < Double.POSITIVE_INFINITY);
            dArray[i] = random.nextDouble() * d + this.bounds.getMin(i);
        }
        return new DoubleVector(dArray);
    }

    private static class Factory
    implements FeatureVector.Factory<UniformContinuousUncertainObject, Number> {
        private Factory() {
        }

        @Override
        public <A> UniformContinuousUncertainObject newFeatureVector(A a, ArrayAdapter<? extends Number, A> arrayAdapter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBufferSerializer<UniformContinuousUncertainObject> getDefaultSerializer() {
            return null;
        }

        @Override
        public Class<? super UniformContinuousUncertainObject> getRestrictionClass() {
            return UniformContinuousUncertainObject.class;
        }
    }
}

