/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database;

import de.lmu.ifi.dbs.elki.data.type.NoSupportedDataTypeException;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseEventManager;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.datasource.bundle.SingleObjectBundle;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SimilarityFunction;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.AbstractHierarchicalResult;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class AbstractDatabase
extends AbstractHierarchicalResult
implements Database {
    protected final DatabaseEventManager eventManager = new DatabaseEventManager();
    protected final List<Relation<?>> relations = new ArrayList();
    protected final Collection<IndexFactory<?, ?>> indexFactories = new ArrayList();

    @Override
    public SingleObjectBundle getBundle(DBIDRef dBIDRef) {
        assert (dBIDRef != null);
        try {
            SingleObjectBundle singleObjectBundle = new SingleObjectBundle();
            for (Relation<?> relation : this.relations) {
                singleObjectBundle.append(relation.getDataTypeInformation(), relation.get(dBIDRef));
            }
            return singleObjectBundle;
        }
        catch (RuntimeException runtimeException) {
            if (dBIDRef == null) {
                throw new UnsupportedOperationException("AbstractDatabase.getPackage(null) called!");
            }
            throw runtimeException;
        }
    }

    @Override
    public Collection<Relation<?>> getRelations() {
        return Collections.unmodifiableCollection(this.relations);
    }

    @Override
    public <O> Relation<O> getRelation(TypeInformation typeInformation, Object ... objectArray) throws NoSupportedDataTypeException {
        for (Relation<?> relation : this.relations) {
            if (!typeInformation.isAssignableFromType(relation.getDataTypeInformation())) continue;
            return relation;
        }
        ArrayList arrayList = new ArrayList(this.relations.size());
        for (Relation relation : this.relations) {
            arrayList.add(relation.getDataTypeInformation());
        }
        throw new NoSupportedDataTypeException(typeInformation, arrayList);
    }

    @Override
    public <O> DistanceQuery<O> getDistanceQuery(Relation<O> relation, DistanceFunction<? super O> distanceFunction, Object ... objectArray) {
        return relation.getDistanceQuery(distanceFunction, objectArray);
    }

    @Override
    public <O> SimilarityQuery<O> getSimilarityQuery(Relation<O> relation, SimilarityFunction<? super O> similarityFunction, Object ... objectArray) {
        return relation.getSimilarityQuery(similarityFunction, objectArray);
    }

    @Override
    public <O> KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        Relation<O> relation = distanceQuery.getRelation();
        return relation.getKNNQuery(distanceQuery, objectArray);
    }

    @Override
    public <O> RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        Relation<O> relation = distanceQuery.getRelation();
        return relation.getRangeQuery(distanceQuery, objectArray);
    }

    @Override
    public <O> RKNNQuery<O> getRKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        Relation<O> relation = distanceQuery.getRelation();
        return relation.getRKNNQuery(distanceQuery, objectArray);
    }

    @Override
    public void addDataStoreListener(DataStoreListener dataStoreListener) {
        this.eventManager.addListener(dataStoreListener);
    }

    @Override
    public void removeDataStoreListener(DataStoreListener dataStoreListener) {
        this.eventManager.removeListener(dataStoreListener);
    }

    @Override
    public void accumulateDataStoreEvents() {
        this.eventManager.accumulateDataStoreEvents();
    }

    @Override
    public void flushDataStoreEvents() {
        this.eventManager.flushDataStoreEvents();
    }

    @Override
    public String getLongName() {
        return "Database";
    }

    @Override
    public String getShortName() {
        return "database";
    }

    protected abstract Logging getLogger();

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID DATABASE_CONNECTION_ID = new OptionID("dbc", "Database connection class.");
        public static final OptionID INDEX_ID = new OptionID("db.index", "Database indexes to add.");

        @Override
        protected abstract Database makeInstance();
    }
}

