/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreIDMap;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import java.util.Arrays;

public class ArrayIntegerStore
implements WritableIntegerDataStore {
    private int[] data;
    private DataStoreIDMap idmap;
    private int def;

    public ArrayIntegerStore(int n, DataStoreIDMap dataStoreIDMap) {
        this(n, dataStoreIDMap, 0);
    }

    public ArrayIntegerStore(int n, DataStoreIDMap dataStoreIDMap, int n2) {
        this.data = new int[n];
        this.def = n2;
        if (n2 != 0) {
            Arrays.fill(this.data, n2);
        }
        this.idmap = dataStoreIDMap;
    }

    @Override
    @Deprecated
    public Integer get(DBIDRef dBIDRef) {
        return this.data[this.idmap.mapDBIDToOffset(dBIDRef)];
    }

    @Override
    @Deprecated
    public Integer put(DBIDRef dBIDRef, Integer n) {
        int n2 = this.idmap.mapDBIDToOffset(dBIDRef);
        int n3 = this.data[n2];
        this.data[n2] = n;
        return n3;
    }

    @Override
    public int intValue(DBIDRef dBIDRef) {
        return this.data[this.idmap.mapDBIDToOffset(dBIDRef)];
    }

    @Override
    public int putInt(DBIDRef dBIDRef, int n) {
        int n2 = this.idmap.mapDBIDToOffset(dBIDRef);
        int n3 = this.data[n2];
        this.data[n2] = n;
        return n3;
    }

    @Override
    public int put(DBIDRef dBIDRef, int n) {
        int n2 = this.idmap.mapDBIDToOffset(dBIDRef);
        int n3 = this.data[n2];
        this.data[n2] = n;
        return n3;
    }

    @Override
    public void increment(DBIDRef dBIDRef, int n) {
        int n2;
        int n3 = n2 = this.idmap.mapDBIDToOffset(dBIDRef);
        this.data[n3] = this.data[n3] + n;
    }

    @Override
    public void destroy() {
        this.data = null;
        this.idmap = null;
    }

    @Override
    public void delete(DBIDRef dBIDRef) {
        this.put(dBIDRef, this.def);
    }

    @Override
    public void clear() {
        Arrays.fill(this.data, this.def);
    }

    @Override
    public String getLongName() {
        return "raw";
    }

    @Override
    public String getShortName() {
        return "raw";
    }
}

