/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreIDMap;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableRecordStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;

public class ArrayRecordStore
implements WritableRecordStore {
    private final Object[][] data;
    private final DataStoreIDMap idmap;

    public ArrayRecordStore(Object[][] objectArray, DataStoreIDMap dataStoreIDMap) {
        this.data = objectArray;
        this.idmap = dataStoreIDMap;
    }

    @Override
    public <T> WritableDataStore<T> getStorage(int n, Class<? super T> clazz) {
        return new StorageAccessor(n);
    }

    protected <T> T get(DBIDRef dBIDRef, int n) {
        return (T)this.data[this.idmap.mapDBIDToOffset(dBIDRef)][n];
    }

    protected <T> T set(DBIDRef dBIDRef, int n, T t) {
        Object object = this.data[this.idmap.mapDBIDToOffset(dBIDRef)][n];
        this.data[this.idmap.mapDBIDToOffset((DBIDRef)dBIDRef)][n] = t;
        return (T)object;
    }

    @Override
    public boolean remove(DBIDRef dBIDRef) {
        throw new UnsupportedOperationException("ArrayStore records cannot be removed.");
    }

    protected class StorageAccessor<T>
    implements WritableDataStore<T> {
        private final int index;

        protected StorageAccessor(int n) {
            this.index = n;
        }

        @Override
        public T get(DBIDRef dBIDRef) {
            return ArrayRecordStore.this.get(dBIDRef, this.index);
        }

        @Override
        public T put(DBIDRef dBIDRef, T t) {
            return ArrayRecordStore.this.set(dBIDRef, this.index, t);
        }

        @Override
        public void destroy() {
            throw new UnsupportedOperationException("ArrayStore record columns cannot (yet) be destroyed.");
        }

        @Override
        public void delete(DBIDRef dBIDRef) {
            this.put(dBIDRef, null);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("ArrayStore record columns cannot (yet) be cleared.");
        }

        @Override
        public String getLongName() {
            return "raw";
        }

        @Override
        public String getShortName() {
            return "raw";
        }
    }
}

