/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.datastore.DBIDDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBID;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDs;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;

class IntegerDBIDVar
implements DBIDVar,
IntegerDBIDs {
    int id;

    protected IntegerDBIDVar() {
        this.id = Integer.MIN_VALUE;
    }

    protected IntegerDBIDVar(DBIDRef dBIDRef) {
        this.id = dBIDRef.internalGetIndex();
    }

    @Override
    public int internalGetIndex() {
        return this.id;
    }

    protected void internalSetIndex(int n) {
        this.id = n;
    }

    @Override
    public void set(DBIDRef dBIDRef) {
        this.id = dBIDRef.internalGetIndex();
    }

    @Override
    public void setFirst(DBIDPair dBIDPair) {
        assert (dBIDPair instanceof IntegerDBIDPair);
        this.id = ((IntegerDBIDPair)dBIDPair).first;
    }

    @Override
    public void setSecond(DBIDPair dBIDPair) {
        assert (dBIDPair instanceof IntegerDBIDPair);
        this.id = ((IntegerDBIDPair)dBIDPair).second;
    }

    @Override
    @Deprecated
    public DBID get(int n) {
        if (n != 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new IntegerDBID(n);
    }

    @Override
    public int size() {
        return this.id < 0 ? 0 : 1;
    }

    @Override
    public boolean isEmpty() {
        return this.id < 0;
    }

    @Override
    public void unset() {
        this.id = Integer.MIN_VALUE;
    }

    @Override
    public boolean isSet() {
        return this.id > 0;
    }

    @Override
    public int binarySearch(DBIDRef dBIDRef) {
        int n = dBIDRef.internalGetIndex();
        return n == this.id ? 0 : (n < this.id ? -1 : -2);
    }

    @Override
    public boolean contains(DBIDRef dBIDRef) {
        return this.id == dBIDRef.internalGetIndex();
    }

    @Override
    public DBIDVar assignVar(int n, DBIDVar dBIDVar) {
        if (dBIDVar instanceof IntegerDBIDVar) {
            ((IntegerDBIDVar)dBIDVar).internalSetIndex(n);
            return dBIDVar;
        }
        dBIDVar.set(this.get(n));
        return dBIDVar;
    }

    @Override
    public DBIDVar from(DBIDDataStore dBIDDataStore, DBIDRef dBIDRef) {
        dBIDDataStore.assignVar(dBIDRef, this);
        return this;
    }

    @Override
    public ArrayDBIDs slice(int n, int n2) {
        if (n == 0 && n2 == 1) {
            return this;
        }
        return DBIDUtil.EMPTYDBIDS;
    }

    public String toString() {
        return this.id != Integer.MIN_VALUE ? Integer.toString(this.id) : "null";
    }

    @Override
    public Itr iter() {
        return new Itr();
    }

    protected class Itr
    implements IntegerDBIDArrayIter,
    IntegerDBIDRef {
        int pos = 0;

        protected Itr() {
        }

        @Override
        public Itr advance() {
            ++this.pos;
            return this;
        }

        @Override
        public Itr advance(int n) {
            this.pos += n;
            return this;
        }

        @Override
        public Itr retract() {
            --this.pos;
            return this;
        }

        @Override
        public Itr seek(int n) {
            this.pos = n;
            return this;
        }

        @Override
        public int getOffset() {
            return this.pos;
        }

        @Override
        public int internalGetIndex() {
            return IntegerDBIDVar.this.id;
        }

        @Override
        public boolean valid() {
            return this.pos == 0;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof DBID) {
                LoggingUtil.warning("Programming error detected: DBIDItr.equals(DBID). Use sameDBID()!", new Throwable());
            }
            return super.equals(object);
        }

        public String toString() {
            return Integer.toString(this.internalGetIndex());
        }
    }
}

