/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDs;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.Iter;
import gnu.trove.impl.hash.THashPrimitiveIterator;
import gnu.trove.impl.hash.TIntHash;
import gnu.trove.set.hash.TIntHashSet;

class TroveHashSetModifiableDBIDs
implements HashSetModifiableDBIDs,
IntegerDBIDs {
    TIntHashSet store;

    protected TroveHashSetModifiableDBIDs(int n) {
        this.store = new TIntHashSet(n);
    }

    protected TroveHashSetModifiableDBIDs() {
        this.store = new TIntHashSet();
    }

    protected TroveHashSetModifiableDBIDs(DBIDs dBIDs) {
        this(dBIDs.size());
        this.addDBIDs(dBIDs);
    }

    @Override
    public Itr iter() {
        return new Itr(this.store);
    }

    @Override
    public boolean addDBIDs(DBIDs dBIDs) {
        this.store.ensureCapacity(dBIDs.size());
        boolean bl = false;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            bl |= this.store.add(DBIDUtil.asInteger(dBIDIter));
            dBIDIter.advance();
        }
        return bl;
    }

    @Override
    public boolean removeDBIDs(DBIDs dBIDs) {
        boolean bl = false;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            bl |= this.store.remove(DBIDUtil.asInteger(dBIDIter));
            dBIDIter.advance();
        }
        return bl;
    }

    @Override
    public boolean add(DBIDRef dBIDRef) {
        return this.store.add(DBIDUtil.asInteger(dBIDRef));
    }

    @Override
    public boolean remove(DBIDRef dBIDRef) {
        return this.store.remove(DBIDUtil.asInteger(dBIDRef));
    }

    @Override
    public boolean retainAll(DBIDs dBIDs) {
        boolean bl = false;
        Itr itr = this.iter();
        while (itr.valid()) {
            if (!dBIDs.contains(itr)) {
                itr.remove();
                bl = true;
            }
            itr.advance();
        }
        return bl;
    }

    @Override
    public int size() {
        return this.store.size();
    }

    @Override
    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    @Override
    public boolean contains(DBIDRef dBIDRef) {
        return this.store.contains(DBIDUtil.asInteger(dBIDRef));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        Itr itr = this.iter();
        while (itr.valid()) {
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(((Object)itr).toString());
            itr.advance();
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public DBIDVar pop(DBIDVar dBIDVar) {
        if (this.store.size() == 0) {
            throw new ArrayIndexOutOfBoundsException("Cannot pop() from an empty array.");
        }
        byte[] byArray = this.store._states;
        int n = this.store.capacity();
        while (n-- > 0 && byArray[n] != 1) {
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Cannot pop() from an empty array.");
        }
        int n2 = this.store._set[n];
        if (dBIDVar instanceof IntegerDBIDVar) {
            ((IntegerDBIDVar)dBIDVar).internalSetIndex(n2);
        } else {
            dBIDVar.set(DBIDUtil.importInteger(n2));
        }
        this.store.remove(n2);
        return dBIDVar;
    }

    protected static class Itr
    implements IntegerDBIDMIter {
        TIntHashItr it;

        public Itr(TIntHash tIntHash) {
            this.it = new TIntHashItr(tIntHash);
        }

        @Override
        public boolean valid() {
            return this.it.valid();
        }

        @Override
        public IntegerDBIDMIter advance() {
            this.it.advance();
            return this;
        }

        @Override
        public int internalGetIndex() {
            return this.it.getInt();
        }

        public String toString() {
            return Integer.toString(this.internalGetIndex());
        }

        @Override
        public void remove() {
            this.it.remove();
        }

        private static class TIntHashItr
        extends THashPrimitiveIterator
        implements Iter {
            private TIntHash hash;

            public TIntHashItr(TIntHash tIntHash) {
                super(tIntHash);
                this.hash = tIntHash;
                this._index = this.nextIndex();
            }

            public int getInt() {
                return this.hash._set[this._index];
            }

            @Override
            public Iter advance() {
                this._index = this.nextIndex();
                return this;
            }

            @Override
            public boolean valid() {
                return this._index >= 0;
            }
        }
    }
}

