/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.normalization.columnwise;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.AbstractNormalization;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.NonNumericFeaturesException;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.LinearEquationSystem;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.AllOrNoneMustBeSetGlobalConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.EqualSizeGlobalConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleListParameter;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.normalization.AttributeWiseMinMaxNormalization", "de.lmu.ifi.dbs.elki.datasource.filter.AttributeWiseMinMaxNormalization"})
public class AttributeWiseMinMaxNormalization<V extends NumberVector>
extends AbstractNormalization<V> {
    private static final Logging LOG = Logging.getLogger(AttributeWiseMinMaxNormalization.class);
    private double[] maxima = new double[0];
    private double[] minima = new double[0];

    public AttributeWiseMinMaxNormalization(double[] dArray, double[] dArray2) {
        this.minima = dArray;
        this.maxima = dArray2;
    }

    @Override
    protected boolean prepareStart(SimpleTypeInformation<V> simpleTypeInformation) {
        return this.minima.length == 0 || this.maxima.length == 0;
    }

    @Override
    protected void prepareProcessInstance(V v) {
        int n;
        if (this.minima.length == 0 || this.maxima.length == 0) {
            n = v.getDimensionality();
            this.minima = new double[n];
            this.maxima = new double[n];
            for (int i = 0; i < n; ++i) {
                this.maxima[i] = -1.7976931348623157E308;
                this.minima[i] = Double.MAX_VALUE;
            }
        }
        if (this.minima.length != v.getDimensionality()) {
            throw new IllegalArgumentException("FeatureVectors differ in length.");
        }
        for (n = 0; n < v.getDimensionality(); ++n) {
            double d = v.doubleValue(n);
            if (d > this.maxima[n]) {
                this.maxima[n] = d;
            }
            if (!(d < this.minima[n])) continue;
            this.minima[n] = d;
        }
    }

    @Override
    protected V filterSingleObject(V v) {
        double[] dArray = new double[v.getDimensionality()];
        if (this.minima.length != v.getDimensionality()) {
            throw new IllegalArgumentException("FeatureVectors and given Minima/Maxima differ in length.");
        }
        for (int i = 0; i < v.getDimensionality(); ++i) {
            dArray[i] = (v.doubleValue(i) - this.minima[i]) / this.factor(i);
        }
        return this.factory.newNumberVector(dArray);
    }

    @Override
    public V restore(V v) throws NonNumericFeaturesException {
        if (v.getDimensionality() != this.maxima.length || v.getDimensionality() != this.minima.length) {
            throw new NonNumericFeaturesException("Attributes cannot be resized: current dimensionality: " + v.getDimensionality() + " former dimensionality: " + this.maxima.length);
        }
        double[] dArray = new double[v.getDimensionality()];
        for (int i = 0; i < v.getDimensionality(); ++i) {
            dArray[i] = v.doubleValue(i) * this.factor(i) + this.minima[i];
        }
        return this.factory.newNumberVector(dArray);
    }

    private double factor(int n) {
        return this.maxima[n] > this.minima[n] ? this.maxima[n] - this.minima[n] : (this.maxima[n] > 0.0 ? this.maxima[n] : 1.0);
    }

    @Override
    public LinearEquationSystem transform(LinearEquationSystem linearEquationSystem) {
        double[][] dArray = linearEquationSystem.getCoefficents();
        double[] dArray2 = linearEquationSystem.getRHS();
        int[] nArray = linearEquationSystem.getRowPermutations();
        int[] nArray2 = linearEquationSystem.getColumnPermutations();
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                double d = 0.0;
                for (int k = 0; k < dArray[0].length; ++k) {
                    d += this.minima[k] * dArray[nArray[j]][nArray2[k]] / this.factor(k);
                    dArray[nArray[j]][nArray2[k]] = dArray[nArray[j]][nArray2[k]] / this.factor(k);
                }
                dArray2[nArray[j]] = dArray2[nArray[j]] + d;
            }
        }
        return new LinearEquationSystem(dArray, dArray2, nArray, nArray2);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("normalization class: ").append(this.getClass().getName());
        stringBuilder.append('\n');
        stringBuilder.append("normalization minima: ").append(FormatUtil.format(this.minima));
        stringBuilder.append('\n');
        stringBuilder.append("normalization maxima: ").append(FormatUtil.format(this.maxima));
        return stringBuilder.toString();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID MINIMA_ID = new OptionID("normalize.min", "a comma separated concatenation of the minimum values in each dimension that are mapped to 0. If no value is specified, the minimum value of the attribute range in this dimension will be taken.");
        public static final OptionID MAXIMA_ID = new OptionID("normalize.max", "a comma separated concatenation of the maximum values in each dimension that are mapped to 1. If no value is specified, the maximum value of the attribute range in this dimension will be taken.");
        private double[] maxima = new double[0];
        private double[] minima = new double[0];

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleListParameter doubleListParameter;
            super.makeOptions(parameterization);
            DoubleListParameter doubleListParameter2 = new DoubleListParameter(MINIMA_ID, true);
            if (parameterization.grab(doubleListParameter2)) {
                this.minima = (double[])((double[])doubleListParameter2.getValue()).clone();
            }
            if (parameterization.grab(doubleListParameter = new DoubleListParameter(MAXIMA_ID, true))) {
                this.maxima = (double[])((double[])doubleListParameter.getValue()).clone();
            }
            parameterization.checkConstraint(new AllOrNoneMustBeSetGlobalConstraint(doubleListParameter2, doubleListParameter));
            parameterization.checkConstraint(new EqualSizeGlobalConstraint(doubleListParameter2, doubleListParameter));
        }

        @Override
        protected AttributeWiseMinMaxNormalization<V> makeInstance() {
            return new AttributeWiseMinMaxNormalization(this.minima, this.maxima);
        }
    }
}

