/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.normalization.instancewise;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.normalization.AbstractStreamNormalization;
import de.lmu.ifi.dbs.elki.distance.distancefunction.Norm;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.normalization.LengthNormalization"})
public class LengthNormalization<V extends NumberVector>
extends AbstractStreamNormalization<V> {
    Norm<? super V> norm;

    public LengthNormalization(Norm<? super V> norm) {
        this.norm = norm;
    }

    @Override
    protected V filterSingleObject(V v) {
        double d = this.norm.norm(v);
        return this.factory.newNumberVector(v.getColumnVector().timesEquals(1.0 / d).getArrayRef());
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID NORM_ID = new OptionID("normalization.norm", "Norm (length function) to use for computing the vector length.");
        Norm<? super V> norm;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(NORM_ID, (Class<?>)Norm.class, EuclideanDistanceFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.norm = (Norm)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected LengthNormalization<V> makeInstance() {
            return new LengthNormalization<V>(this.norm);
        }
    }
}

