/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.selection;

import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractStreamFilter;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.Random;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.RandomSamplingStreamFilter"})
public class RandomSamplingStreamFilter
extends AbstractStreamFilter {
    protected double prob;
    protected Random random;

    public RandomSamplingStreamFilter(double d, RandomFactory randomFactory) {
        this.prob = d;
        this.random = randomFactory.getSingleThreadedRandom();
    }

    @Override
    public BundleMeta getMeta() {
        return this.source.getMeta();
    }

    @Override
    public Object data(int n) {
        return this.source.data(n);
    }

    @Override
    public BundleStreamSource.Event nextEvent() {
        block5: while (true) {
            BundleStreamSource.Event event = this.source.nextEvent();
            switch (event) {
                case END_OF_STREAM: {
                    return event;
                }
                case META_CHANGED: {
                    return event;
                }
                case NEXT_OBJECT: {
                    if (!(this.random.nextDouble() < this.prob)) continue block5;
                    return event;
                }
            }
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        private static final OptionID PROB_ID = new OptionID("sampling.p", "Sampling probability. Each object has a chance of being samples with this probability.");
        private static final OptionID SEED_ID = new OptionID("sampling.seed", "Random generator seed for sampling.");
        protected double prob;
        protected RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = (DoubleParameter)((DoubleParameter)new DoubleParameter(PROB_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).addConstraint(CommonConstraints.LESS_EQUAL_ONE_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.prob = (Double)doubleParameter.getValue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(SEED_ID))) {
                this.rnd = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected RandomSamplingStreamFilter makeInstance() {
            return new RandomSamplingStreamFilter(this.prob, this.rnd);
        }
    }
}

