/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.transform;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractVectorConversionFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.MeanVarianceMinMax;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.AllOrNoneMustBeSetGlobalConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.EqualSizeGlobalConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.LongParameter;
import java.util.Random;

@Title(value="Data Perturbation for Outlier Detection Ensembles")
@Description(value="A filter to perturb a datasset on read by an additive noise component, implemented for use in an outlier ensemble (this reference).")
@Reference(authors="A. Zimek, R. J. G. B. Campello, J. Sander", title="Data Perturbation for Outlier Detection Ensembles", booktitle="Proc. 26th International Conference on Scientific and Statistical Database Management (SSDBM), Aalborg, Denmark, 2014", url="http://dx.doi.org/10.1145/2618243.2618257")
public class PerturbationFilter<V extends NumberVector>
extends AbstractVectorConversionFilter<V, V> {
    private static final Logging LOG = Logging.getLogger(PerturbationFilter.class);
    private ScalingReference scalingreference;
    private NoiseDistribution noisedistribution;
    private final Random RANDOM;
    private double percentage;
    private MeanVarianceMinMax[] mvs = null;
    private double[] scalingreferencevalues = new double[0];
    private Random[] randomPerAttribute = null;
    private double[] maxima;
    private double[] minima;
    private int dimensionality = 0;

    public PerturbationFilter(Long l, double d, ScalingReference scalingReference, double[] dArray, double[] dArray2, NoiseDistribution noiseDistribution) {
        this.percentage = d;
        this.scalingreference = scalingReference;
        this.minima = dArray;
        this.maxima = dArray2;
        this.noisedistribution = noiseDistribution;
        this.RANDOM = l == null ? new Random() : new Random(l);
    }

    @Override
    protected boolean prepareStart(SimpleTypeInformation<V> simpleTypeInformation) {
        if (this.scalingreference == ScalingReference.MINMAX && this.minima.length != 0 && this.maxima.length != 0) {
            this.dimensionality = this.minima.length;
            this.scalingreferencevalues = new double[this.dimensionality];
            this.randomPerAttribute = new Random[this.dimensionality];
            for (int i = 0; i < this.dimensionality; ++i) {
                this.scalingreferencevalues[i] = (this.maxima[i] - this.minima[i]) * this.percentage;
                if (this.scalingreferencevalues[i] == 0.0 || Double.isNaN(this.scalingreferencevalues[i])) {
                    this.scalingreferencevalues[i] = this.percentage;
                }
                this.randomPerAttribute[i] = new Random(this.RANDOM.nextLong());
            }
            return false;
        }
        if (this.scalingreference == ScalingReference.UNITCUBE) {
            return false;
        }
        return this.scalingreferencevalues.length == 0;
    }

    @Override
    protected void prepareProcessInstance(V v) {
        if (this.mvs == null) {
            this.dimensionality = v.getDimensionality();
            this.mvs = MeanVarianceMinMax.newArray(this.dimensionality);
        }
        for (int i = 0; i < v.getDimensionality(); ++i) {
            this.mvs[i].put(v.doubleValue(i));
        }
    }

    @Override
    protected void prepareComplete() {
        StringBuilder stringBuilder = LOG.isDebuggingFine() ? new StringBuilder() : null;
        this.scalingreferencevalues = new double[this.dimensionality];
        this.randomPerAttribute = new Random[this.dimensionality];
        if (this.scalingreference == ScalingReference.STDDEV) {
            if (stringBuilder != null) {
                stringBuilder.append("Standard deviation per attribute: ");
            }
            for (int i = 0; i < this.dimensionality; ++i) {
                this.scalingreferencevalues[i] = this.mvs[i].getSampleStddev() * this.percentage;
                if (this.scalingreferencevalues[i] == 0.0 || Double.isNaN(this.scalingreferencevalues[i])) {
                    this.scalingreferencevalues[i] = this.percentage;
                }
                this.randomPerAttribute[i] = new Random(this.RANDOM.nextLong());
                if (stringBuilder == null) continue;
                stringBuilder.append(" ").append(i).append(": ").append(this.scalingreferencevalues[i] / this.percentage);
            }
        } else if (this.scalingreference == ScalingReference.MINMAX && this.minima.length == 0 && this.maxima.length == 0) {
            if (stringBuilder != null) {
                stringBuilder.append("extension per attribute: ");
            }
            for (int i = 0; i < this.dimensionality; ++i) {
                this.scalingreferencevalues[i] = (this.mvs[i].getMax() - this.mvs[i].getMin()) * this.percentage;
                if (this.scalingreferencevalues[i] == 0.0 || Double.isNaN(this.scalingreferencevalues[i])) {
                    this.scalingreferencevalues[i] = this.percentage;
                }
                this.randomPerAttribute[i] = new Random(this.RANDOM.nextLong());
                if (stringBuilder == null) continue;
                stringBuilder.append(" ").append(i).append(": ").append(this.scalingreferencevalues[i] / this.percentage);
            }
        }
        this.mvs = null;
        if (stringBuilder != null) {
            LOG.debugFine(stringBuilder.toString());
        }
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    protected V filterSingleObject(V v) {
        if (this.scalingreference == ScalingReference.UNITCUBE && this.dimensionality == 0) {
            this.dimensionality = v.getDimensionality();
            this.scalingreferencevalues = new double[this.dimensionality];
            this.randomPerAttribute = new Random[this.dimensionality];
            for (int i = 0; i < this.dimensionality; ++i) {
                this.scalingreferencevalues[i] = this.percentage;
                this.randomPerAttribute[i] = new Random(this.RANDOM.nextLong());
            }
        }
        if (this.scalingreferencevalues.length != v.getDimensionality()) {
            throw new IllegalArgumentException("FeatureVectors and given Minima/Maxima differ in length.");
        }
        double[] dArray = new double[v.getDimensionality()];
        for (int i = 0; i < v.getDimensionality(); ++i) {
            if (this.noisedistribution.equals((Object)NoiseDistribution.GAUSSIAN)) {
                dArray[i] = v.doubleValue(i) + this.randomPerAttribute[i].nextGaussian() * this.scalingreferencevalues[i];
                continue;
            }
            if (!this.noisedistribution.equals((Object)NoiseDistribution.UNIFORM)) continue;
            dArray[i] = v.doubleValue(i) + this.randomPerAttribute[i].nextDouble() * this.scalingreferencevalues[i];
        }
        return this.factory.newNumberVector(dArray);
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> simpleTypeInformation) {
        this.initializeOutputType(simpleTypeInformation);
        return simpleTypeInformation;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID MINIMA_ID = new OptionID("perturbationfilter.min", "Only used, if " + (Object)((Object)ScalingReference.MINMAX) + " is set as scaling reference: a comma separated concatenation of the minimum values in each dimension assumed as a reference. If no value is specified, the minimum value of the attribute range in this dimension will be taken.");
        public static final OptionID MAXIMA_ID = new OptionID("perturbationfilter.max", "Only used, if " + (Object)((Object)ScalingReference.MINMAX) + " is set as scaling reference: a comma separated concatenation of the maximum values in each dimension assumed as a reference. If no value is specified, the maximum value of the attribute range in this dimension will be taken.");
        private double[] maxima = new double[0];
        private double[] minima = new double[0];
        public static final OptionID SEED_ID = new OptionID("perturbationfilter.seed", "Seed for random noise generation.");
        protected Long seed = null;
        public static final OptionID PERCENTAGE_ID = new OptionID("perturbationfilter.percentage", "Percentage of the standard deviation of the random Gaussian noise generation per attribute, given the standard deviation of the corresponding attribute in the original data distribution (assuming a Gaussian distribution there).");
        public static final OptionID SCALINGREFERENCE_ID = new OptionID("perturbationfilter.scalingreference", "The reference for scaling the Gaussian noise. Default is " + (Object)((Object)ScalingReference.UNITCUBE) + ", parameter " + PERCENTAGE_ID.getName() + " will then directly define the standard deviation of all noise Gaussians. For options " + (Object)((Object)ScalingReference.STDDEV) + " and  " + (Object)((Object)ScalingReference.MINMAX) + ", the percentage of the attributewise standard deviation or extension, repectively, will define the attributewise standard deviation of the noise Gaussians.");
        public static final OptionID NOISEDISTRIBUTION_ID = new OptionID("perturbationfilter.noisedistribution", "The nature of the noise distribution, default is " + (Object)((Object)NoiseDistribution.UNIFORM));
        protected double percentage;
        protected ScalingReference scalingreference;
        protected NoiseDistribution noisedistribution;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            EnumParameter<NoiseDistribution> enumParameter;
            super.makeOptions(parameterization);
            EnumParameter<ScalingReference> enumParameter2 = new EnumParameter<ScalingReference>(SCALINGREFERENCE_ID, ScalingReference.class, ScalingReference.UNITCUBE);
            if (parameterization.grab(enumParameter2)) {
                this.scalingreference = (ScalingReference)((Object)enumParameter2.getValue());
            }
            if (parameterization.grab(enumParameter = new EnumParameter<NoiseDistribution>(NOISEDISTRIBUTION_ID, NoiseDistribution.class, NoiseDistribution.UNIFORM))) {
                this.noisedistribution = (NoiseDistribution)((Object)enumParameter.getValue());
            }
            DoubleParameter doubleParameter = new DoubleParameter(PERCENTAGE_ID, 0.01);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            doubleParameter.addConstraint(CommonConstraints.LESS_EQUAL_ONE_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.percentage = (Double)doubleParameter.getValue();
            }
            LongParameter longParameter = new LongParameter(SEED_ID);
            longParameter.setOptional(true);
            if (parameterization.grab(longParameter)) {
                this.seed = (Long)longParameter.getValue();
            }
            DoubleListParameter doubleListParameter = new DoubleListParameter(MINIMA_ID);
            doubleListParameter.setOptional(true);
            if (parameterization.grab(doubleListParameter)) {
                this.minima = (double[])((double[])doubleListParameter.getValue()).clone();
            }
            DoubleListParameter doubleListParameter2 = new DoubleListParameter(MAXIMA_ID);
            doubleListParameter2.setOptional(true);
            if (parameterization.grab(doubleListParameter2)) {
                this.maxima = (double[])((double[])doubleListParameter2.getValue()).clone();
            }
            parameterization.checkConstraint(new AllOrNoneMustBeSetGlobalConstraint(doubleListParameter, doubleListParameter2));
            parameterization.checkConstraint(new EqualSizeGlobalConstraint(doubleListParameter, doubleListParameter2));
        }

        @Override
        protected PerturbationFilter<V> makeInstance() {
            return new PerturbationFilter(this.seed, this.percentage, this.scalingreference, this.minima, this.maxima, this.noisedistribution);
        }
    }

    public static enum NoiseDistribution {
        GAUSSIAN,
        UNIFORM;

    }

    public static enum ScalingReference {
        UNITCUBE,
        STDDEV,
        MINMAX;

    }
}

