/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.parser;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.parser.AbstractStreamingParser;
import de.lmu.ifi.dbs.elki.datasource.parser.CSVReaderFormat;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.DoubleArray;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hash.Unique;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

@Alias(value={"de.lmu.ifi.dbs.elki.parser.NumberVectorLabelParser", "de.lmu.ifi.dbs.elki.parser.RealVectorLabelParser"})
public class NumberVectorLabelParser<V extends NumberVector>
extends AbstractStreamingParser {
    private static final Logging LOG = Logging.getLogger(NumberVectorLabelParser.class);
    private long[] labelIndices;
    protected NumberVector.Factory<V> factory;
    protected int mindim;
    protected int maxdim;
    protected BundleMeta meta = null;
    protected List<String> columnnames = null;
    protected boolean haslabels = false;
    protected V curvec = null;
    protected LabelList curlbl = null;
    protected DoubleArray attributes = new DoubleArray(11);
    final ArrayList<String> labels = new ArrayList();
    Unique<String> unique = new Unique();
    BundleStreamSource.Event nextevent = null;

    public NumberVectorLabelParser(CSVReaderFormat cSVReaderFormat, long[] lArray, NumberVector.Factory<V> factory) {
        super(cSVReaderFormat);
        this.labelIndices = lArray;
        this.factory = factory;
    }

    public NumberVectorLabelParser(NumberVector.Factory<V> factory) {
        this(CSVReaderFormat.DEFAULT_FORMAT, null, factory);
    }

    public NumberVectorLabelParser(Pattern pattern, String string, Pattern pattern2, long[] lArray, NumberVector.Factory<V> factory) {
        this(new CSVReaderFormat(pattern, string, pattern2), lArray, factory);
    }

    protected boolean isLabelColumn(int n) {
        return this.labelIndices != null && BitsUtil.get(this.labelIndices, n);
    }

    @Override
    public void initStream(InputStream inputStream) {
        super.initStream(inputStream);
        this.mindim = Integer.MAX_VALUE;
        this.maxdim = 0;
        this.columnnames = null;
        this.haslabels = false;
        this.nextevent = null;
    }

    @Override
    public BundleMeta getMeta() {
        return this.meta;
    }

    @Override
    public BundleStreamSource.Event nextEvent() {
        if (this.nextevent != null) {
            BundleStreamSource.Event event = this.nextevent;
            this.nextevent = null;
            return event;
        }
        try {
            while (this.reader.nextLineExceptComments()) {
                if (!this.parseLineInternal()) continue;
                int n = this.curvec.getDimensionality();
                if (n > this.maxdim || this.mindim > n) {
                    this.mindim = n < this.mindim ? n : this.mindim;
                    this.maxdim = n > this.maxdim ? n : this.maxdim;
                    this.buildMeta();
                    this.nextevent = BundleStreamSource.Event.NEXT_OBJECT;
                    return BundleStreamSource.Event.META_CHANGED;
                }
                if (this.curlbl != null && this.meta != null && this.haslabels && this.meta.size() == 1) {
                    this.buildMeta();
                    this.nextevent = BundleStreamSource.Event.NEXT_OBJECT;
                    return BundleStreamSource.Event.META_CHANGED;
                }
                return BundleStreamSource.Event.NEXT_OBJECT;
            }
            return BundleStreamSource.Event.END_OF_STREAM;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error while parsing line " + this.reader.getLineNumber() + ".");
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.unique.clear();
    }

    protected void buildMeta() {
        if (this.haslabels) {
            this.meta = new BundleMeta(2);
            this.meta.add(this.getTypeInformation(this.mindim, this.maxdim));
            this.meta.add(TypeUtil.LABELLIST);
        } else {
            this.meta = new BundleMeta(1);
            this.meta.add(this.getTypeInformation(this.mindim, this.maxdim));
        }
    }

    @Override
    public Object data(int n) {
        if (n > 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return n == 0 ? this.curvec : this.curlbl;
    }

    protected boolean parseLineInternal() {
        int n = 0;
        while (this.tokenizer.valid()) {
            block6: {
                String string;
                if (!this.isLabelColumn(n) && !this.tokenizer.isQuoted()) {
                    try {
                        this.attributes.add(this.tokenizer.getDouble());
                        break block6;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((string = this.tokenizer.getStrippedSubstring()).length() > 0) {
                    this.haslabels = true;
                    string = this.unique.addOrGet(string);
                    this.labels.add(string);
                }
            }
            this.tokenizer.advance();
            ++n;
        }
        if (this.reader.getLineNumber() == 1 && this.attributes.size == 0) {
            this.columnnames = new ArrayList<String>(this.labels);
            this.haslabels = false;
            this.curvec = null;
            this.curlbl = null;
            return false;
        }
        this.curvec = this.createVector();
        this.curlbl = LabelList.make(this.labels);
        this.attributes.clear();
        this.labels.clear();
        return true;
    }

    protected V createVector() {
        return this.factory.newNumberVector(this.attributes, this.attributes);
    }

    SimpleTypeInformation<V> getTypeInformation(int n, int n2) {
        if (n > n2) {
            throw new AbortException("No vectors were read from the input file - cannot determine vector data type.");
        }
        if (n == n2) {
            String[] stringArray = null;
            if (this.columnnames != null && n <= this.columnnames.size()) {
                stringArray = new String[n];
                int n3 = 0;
                for (int i = 0; i < n; ++i) {
                    if (this.isLabelColumn(i)) continue;
                    stringArray[n3] = this.columnnames.get(i);
                    ++n3;
                }
                if (n3 != n) {
                    stringArray = null;
                }
            }
            return new VectorFieldTypeInformation(this.factory, n, stringArray);
        }
        return new VectorTypeInformation(this.factory, this.factory.getDefaultSerializer(), n, n2);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractStreamingParser.Parameterizer {
        public static final OptionID LABEL_INDICES_ID = new OptionID("parser.labelIndices", "A comma separated list of the indices of labels (may be numeric), counting whitespace separated entries in a line starting with 0. The corresponding entries will be treated as a label.");
        public static final OptionID VECTOR_TYPE_ID = new OptionID("parser.vector-type", "The type of vectors to create for numerical attributes.");
        protected long[] labelIndices;
        protected NumberVector.Factory<V> factory;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            this.getLabelIndices(parameterization);
            this.getFactory(parameterization);
        }

        protected void getFactory(Parameterization parameterization) {
            ObjectParameter objectParameter = new ObjectParameter(VECTOR_TYPE_ID, (Class<?>)NumberVector.Factory.class, DoubleVector.Factory.class);
            if (parameterization.grab(objectParameter)) {
                this.factory = (NumberVector.Factory)objectParameter.instantiateClass(parameterization);
            }
        }

        protected void getLabelIndices(Parameterization parameterization) {
            IntListParameter intListParameter = new IntListParameter(LABEL_INDICES_ID, true);
            if (parameterization.grab(intListParameter)) {
                this.labelIndices = intListParameter.getValueAsBitSet();
            }
        }

        @Override
        protected NumberVectorLabelParser<V> makeInstance() {
            return new NumberVectorLabelParser<V>(this.format, this.labelIndices, this.factory);
        }
    }
}

