/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractSpatialNorm;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="M.-M. Deza and E. Deza", title="Dictionary of distances", booktitle="Dictionary of distances")
public class LorentzianDistanceFunction
extends AbstractSpatialNorm {
    public static final LorentzianDistanceFunction STATIC = new LorentzianDistanceFunction();

    @Deprecated
    public LorentzianDistanceFunction() {
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        int n = LorentzianDistanceFunction.dimensionality(numberVector, numberVector2);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = numberVector.doubleValue(i);
            double d3 = numberVector2.doubleValue(i);
            d += Math.log(1.0 + Math.abs(d2 - d3));
        }
        return d;
    }

    @Override
    public double norm(NumberVector numberVector) {
        int n = numberVector.getDimensionality();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = numberVector.doubleValue(i);
            d += Math.log(1.0 + Math.abs(d2));
        }
        return d;
    }

    @Override
    public double minDist(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        int n = LorentzianDistanceFunction.dimensionality(spatialComparable, spatialComparable2);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2;
            double d3 = spatialComparable.getMin(i);
            double d4 = spatialComparable.getMax(i);
            double d5 = spatialComparable2.getMin(i);
            double d6 = spatialComparable2.getMax(i);
            if (d4 < d5) {
                d2 = d5 - d4;
            } else {
                if (!(d3 > d6)) continue;
                d2 = d3 - d6;
            }
            d += Math.log(1.0 + d2);
        }
        return d;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LorentzianDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

