/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.colorhistogram;

import de.lmu.ifi.dbs.elki.distance.distancefunction.MatrixWeightedDistanceFunction;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Reference(authors="J. Hafner, H. S.Sawhney, W. Equits, M. Flickner, W. Niblack", title="Efficient Color Histogram Indexing for Quadratic Form Distance Functions", booktitle="IEEE Trans. on Pattern Analysis and Machine Intelligence, Vol. 17, No. 7, July 1995", url="http://dx.doi.org/10.1109/34.391417")
public class RGBHistogramQuadraticDistanceFunction
extends MatrixWeightedDistanceFunction {
    public static final OptionID BPP_ID = new OptionID("rgbhist.bpp", "The dimensionality of the histogram in each color");

    public RGBHistogramQuadraticDistanceFunction(int n) {
        super(RGBHistogramQuadraticDistanceFunction.computeWeightMatrix(n));
    }

    public static Matrix computeWeightMatrix(int n) {
        int n2 = n * n * n;
        Matrix matrix = new Matrix(n2, n2);
        double d = 3.0 * ((double)n - 1.0);
        for (int i = 0; i < n2; ++i) {
            int n3 = i / n / n;
            int n4 = i / n % n;
            int n5 = i % n;
            for (int j = 0; j < n2; ++j) {
                int n6 = j / n / n;
                int n7 = j / n % n;
                int n8 = j % n;
                double d2 = Math.abs(n3 - n6);
                double d3 = Math.abs(n4 - n7);
                double d4 = Math.abs(n5 - n8);
                double d5 = 1.0 - (d2 + d3 + d4) / d;
                matrix.set(i, j, d5);
            }
        }
        return matrix;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        return this.weightMatrix.equals(((RGBHistogramQuadraticDistanceFunction)object).weightMatrix);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        int bpp = 0;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(BPP_ID);
            if (parameterization.grab(intParameter)) {
                this.bpp = (Integer)intParameter.getValue();
            }
        }

        @Override
        protected RGBHistogramQuadraticDistanceFunction makeInstance() {
            return new RGBHistogramQuadraticDistanceFunction(this.bpp);
        }
    }
}

