/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.correlation;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.WeightedNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleListParameter;
import java.util.Arrays;

public class WeightedPearsonCorrelationDistanceFunction
extends AbstractNumberVectorDistanceFunction
implements WeightedNumberVectorDistanceFunction<NumberVector> {
    private double[] weights;

    public WeightedPearsonCorrelationDistanceFunction(double[] dArray) {
        this.weights = dArray;
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        return 1.0 - MathUtil.weightedPearsonCorrelationCoefficient(numberVector, numberVector2, this.weights);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        return Arrays.equals(this.weights, ((WeightedPearsonCorrelationDistanceFunction)object).weights);
    }

    public String toString() {
        return "WeightedPearsonCorrelationDistanceFunction";
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected double[] weights;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleListParameter doubleListParameter = new DoubleListParameter(WeightedNumberVectorDistanceFunction.WEIGHTS_ID);
            if (parameterization.grab(doubleListParameter)) {
                this.weights = (double[])((double[])doubleListParameter.getValue()).clone();
            }
        }

        @Override
        protected WeightedPearsonCorrelationDistanceFunction makeInstance() {
            return new WeightedPearsonCorrelationDistanceFunction(this.weights);
        }
    }
}

