/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.geo;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractSpatialDistanceFunction;
import de.lmu.ifi.dbs.elki.math.geodesy.EarthModel;
import de.lmu.ifi.dbs.elki.math.geodesy.SphericalVincentyEarthModel;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.NotImplementedException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class LatLngDistanceFunction
extends AbstractSpatialDistanceFunction {
    private EarthModel model;

    public LatLngDistanceFunction(EarthModel earthModel) {
        this.model = earthModel;
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        return this.model.distanceDeg(numberVector.doubleValue(0), numberVector.doubleValue(1), numberVector2.doubleValue(0), numberVector2.doubleValue(1));
    }

    @Override
    @Reference(authors="Erich Schubert, Arthur Zimek and Hans-Peter Kriegel", title="Geodetic Distance Queries on R-Trees for Indexing Geographic Data", booktitle="Advances in Spatial and Temporal Databases - 13th International Symposium, SSTD 2013, Munich, Germany")
    public double minDist(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        if (spatialComparable instanceof NumberVector) {
            if (spatialComparable2 instanceof NumberVector) {
                return this.distance((NumberVector)spatialComparable, (NumberVector)spatialComparable2);
            }
            NumberVector numberVector = (NumberVector)spatialComparable;
            return this.model.minDistDeg(numberVector.doubleValue(0), numberVector.doubleValue(1), spatialComparable2.getMin(0), spatialComparable2.getMin(1), spatialComparable2.getMax(0), spatialComparable2.getMax(1));
        }
        if (spatialComparable2 instanceof NumberVector) {
            NumberVector numberVector = (NumberVector)spatialComparable2;
            return this.model.minDistDeg(numberVector.doubleValue(0), numberVector.doubleValue(1), spatialComparable.getMin(0), spatialComparable.getMin(1), spatialComparable.getMax(0), spatialComparable.getMax(1));
        }
        throw new NotImplementedException("This distance function cannot - yet - be used with this algorithm, as the lower bound rectangle to rectangle distances have not yet been formalized for geodetic data.");
    }

    @Override
    public SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD_2D;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.model == null ? 0 : this.model.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LatLngDistanceFunction latLngDistanceFunction = (LatLngDistanceFunction)object;
        return !(this.model == null ? latLngDistanceFunction.model != null : !this.model.equals(latLngDistanceFunction.model));
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        EarthModel model;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(EarthModel.MODEL_ID, (Class<?>)EarthModel.class, SphericalVincentyEarthModel.class);
            if (parameterization.grab(objectParameter)) {
                this.model = (EarthModel)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected LatLngDistanceFunction makeInstance() {
            return new LatLngDistanceFunction(this.model);
        }
    }
}

