/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.subspace;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.AbstractDimensionsSelectingDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.SubspaceLPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;

@Alias(value={"de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.DimensionsSelectingEuclideanDistanceFunction"})
public class SubspaceEuclideanDistanceFunction
extends SubspaceLPNormDistanceFunction {
    public SubspaceEuclideanDistanceFunction(long[] lArray) {
        super(2.0, lArray);
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        if (numberVector.getDimensionality() != numberVector2.getDimensionality()) {
            throw new IllegalArgumentException("Different dimensionality of FeatureVectors\n  first argument: " + numberVector + "\n  " + "second argument: " + numberVector2);
        }
        double d = 0.0;
        int n = BitsUtil.nextSetBit(this.dimensions, 0);
        while (n >= 0) {
            double d2 = numberVector.doubleValue(n) - numberVector2.doubleValue(n);
            d += d2 * d2;
            n = BitsUtil.nextSetBit(this.dimensions, n + 1);
        }
        return Math.sqrt(d);
    }

    @Override
    protected double minDistObject(SpatialComparable spatialComparable, NumberVector numberVector) {
        if (spatialComparable.getDimensionality() != numberVector.getDimensionality()) {
            throw new IllegalArgumentException("Different dimensionality of objects\n  first argument: " + spatialComparable.toString() + "\n  " + "second argument: " + numberVector.toString());
        }
        double d = 0.0;
        int n = BitsUtil.nextSetBit(this.dimensions, 0);
        while (n >= 0) {
            block7: {
                double d2;
                block6: {
                    double d3;
                    block5: {
                        double d4;
                        d3 = numberVector.doubleValue(n);
                        if (!(d3 < (d4 = spatialComparable.getMin(n)))) break block5;
                        d2 = d4 - d3;
                        break block6;
                    }
                    double d5 = spatialComparable.getMax(n);
                    if (!(d3 > d5)) break block7;
                    d2 = d3 - d5;
                }
                d += d2 * d2;
            }
            n = BitsUtil.nextSetBit(this.dimensions, n + 1);
        }
        return Math.sqrt(d);
    }

    @Override
    public double minDist(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        if (spatialComparable.getDimensionality() != spatialComparable2.getDimensionality()) {
            throw new IllegalArgumentException("Different dimensionality of objects\n  first argument: " + spatialComparable.toString() + "\n  " + "second argument: " + spatialComparable2.toString());
        }
        double d = 0.0;
        int n = BitsUtil.nextSetBit(this.dimensions, 0);
        while (n >= 0) {
            block7: {
                double d2;
                block6: {
                    double d3;
                    block5: {
                        double d4;
                        double d5 = spatialComparable.getMax(n);
                        if (!(d5 < (d4 = spatialComparable2.getMin(n)))) break block5;
                        d2 = d4 - d5;
                        break block6;
                    }
                    double d6 = spatialComparable.getMin(n);
                    if (!(d6 > (d3 = spatialComparable2.getMax(n)))) break block7;
                    d2 = d6 - d3;
                }
                d += d2 * d2;
            }
            n = BitsUtil.nextSetBit(this.dimensions, n + 1);
        }
        return Math.sqrt(d);
    }

    @Override
    public double norm(NumberVector numberVector) {
        double d = 0.0;
        int n = BitsUtil.nextSetBit(this.dimensions, 0);
        while (n >= 0) {
            double d2 = numberVector.doubleValue(n);
            d += d2 * d2;
            n = BitsUtil.nextSetBit(this.dimensions, n + 1);
        }
        return Math.sqrt(d);
    }

    public static class Parameterizer
    extends AbstractDimensionsSelectingDistanceFunction.Parameterizer {
        @Override
        protected SubspaceEuclideanDistanceFunction makeInstance() {
            return new SubspaceEuclideanDistanceFunction(this.dimensions);
        }
    }
}

