/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering;

import de.lmu.ifi.dbs.elki.evaluation.clustering.ClusterContingencyTable;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="Meil\u0103, M", title="Comparing clusterings", booktitle="University of Washington, Seattle, Technical Report 418, 2002", url="http://www.stat.washington.edu/mmp/Papers/compare-colt.pdf")
public class SetMatchingPurity {
    protected double smPurity = -1.0;
    protected double smInversePurity = -1.0;
    protected double smFFirst = -1.0;
    protected double smFSecond = -1.0;

    protected SetMatchingPurity(ClusterContingencyTable clusterContingencyTable) {
        int n;
        double d;
        double d2;
        int n2;
        int n3 = clusterContingencyTable.contingency[clusterContingencyTable.size1][clusterContingencyTable.size2];
        this.smPurity = 0.0;
        this.smFFirst = 0.0;
        for (n2 = 0; n2 < clusterContingencyTable.size1; ++n2) {
            d2 = 0.0;
            d = 0.0;
            for (n = 0; n < clusterContingencyTable.size2; ++n) {
                d2 = Math.max(d2, 1.0 * (double)clusterContingencyTable.contingency[n2][n]);
                d = Math.max(d, 2.0 * (double)clusterContingencyTable.contingency[n2][n] / (double)(clusterContingencyTable.contingency[n2][clusterContingencyTable.size2] + clusterContingencyTable.contingency[clusterContingencyTable.size1][n]));
            }
            this.smPurity += d2 / (double)n3;
            this.smFFirst += (double)clusterContingencyTable.contingency[n2][clusterContingencyTable.size2] / (double)clusterContingencyTable.contingency[clusterContingencyTable.size1][clusterContingencyTable.size2] * d;
        }
        this.smInversePurity = 0.0;
        this.smFSecond = 0.0;
        for (n2 = 0; n2 < clusterContingencyTable.size2; ++n2) {
            d2 = 0.0;
            d = 0.0;
            for (n = 0; n < clusterContingencyTable.size1; ++n) {
                d2 = Math.max(d2, 1.0 * (double)clusterContingencyTable.contingency[n][n2]);
                d = Math.max(d, 2.0 * (double)clusterContingencyTable.contingency[n][n2] / (double)(clusterContingencyTable.contingency[n][clusterContingencyTable.size2] + clusterContingencyTable.contingency[clusterContingencyTable.size1][n2]));
            }
            this.smInversePurity += d2 / (double)n3;
            this.smFSecond += (double)clusterContingencyTable.contingency[clusterContingencyTable.size1][n2] / (double)clusterContingencyTable.contingency[clusterContingencyTable.size1][clusterContingencyTable.size2] * d;
        }
    }

    @Reference(authors="Zhao, Y. and Karypis, G.", title="Criterion functions for document clustering: Experiments and analysis", booktitle="University of Minnesota, Department of Computer Science, Technical Report 01-40, 2001", url="http://www-users.cs.umn.edu/~karypis/publications/Papers/PDF/vscluster.pdf")
    public double purity() {
        return this.smPurity;
    }

    public double inversePurity() {
        return this.smInversePurity;
    }

    @Reference(authors="Steinbach, M. and Karypis, G. and Kumar, V.", title="A comparison of document clustering techniques", booktitle="KDD workshop on text mining, 2000", url="http://www-users.itlabs.umn.edu/~karypis/publications/Papers/PDF/doccluster.pdf")
    public double f1Measure() {
        return ClusterContingencyTable.Util.f1Measure(this.purity(), this.inversePurity());
    }

    @Reference(authors="E. Amigo\u0301, J. Gonzalo, J. Artiles, and F. Verdejo", title="A comparison of extrinsic clustering evaluation metrics based on formal constraints", booktitle="Inf. Retrieval, vol. 12, no. 5", url="http://dx.doi.org/10.1007/s10791-009-9106-z")
    public double fMeasureFirst() {
        return this.smFFirst;
    }

    @Reference(authors="E. Amigo\u0301, J. Gonzalo, J. Artiles, and F. Verdejo", title="A comparison of extrinsic clustering evaluation metrics based on formal constraints", booktitle="Inf. Retrieval, vol. 12, no. 5", url="http://dx.doi.org/10.1007/s10791-009-9106-z")
    public double fMeasureSecond() {
        return this.smFSecond;
    }
}

