/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.internal;

import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.EvaluateSimplifiedSilhouette;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.EvaluateVarianceRatioCriteria;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.NoiseHandling;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

@Reference(authors="M. K. Pakhira, and S. Bandyopadhyay, and U. Maulik", title="Validity index for crisp and fuzzy clusters", booktitle="Pattern recognition, 37(3)", url="http://dx.doi.org/10.1016/j.patcog.2003.06.005")
public class EvaluatePBMIndex
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(EvaluatePBMIndex.class);
    private NoiseHandling noiseHandling;
    private NumberVectorDistanceFunction<?> distanceFunction;
    private String key = EvaluatePBMIndex.class.getName();

    public EvaluatePBMIndex(NumberVectorDistanceFunction<?> numberVectorDistanceFunction, NoiseHandling noiseHandling) {
        this.distanceFunction = numberVectorDistanceFunction;
        this.noiseHandling = noiseHandling;
    }

    /*
     * Unable to fully structure code
     */
    public double evaluateClustering(Database var1_1, Relation<? extends NumberVector> var2_2, Clustering<?> var3_3) {
        var4_4 = var3_3.getAllClusters();
        var5_5 = new NumberVector[var4_4.size()];
        var6_6 = EvaluateSimplifiedSilhouette.centroids(var2_2, var4_4, var5_5, this.noiseHandling);
        var7_7 = RelationUtil.dimensionality(var2_2);
        var8_8 = new Centroid(var7_7);
        EvaluateVarianceRatioCriteria.globalCentroid(var8_8, var2_2, var4_4, var5_5, this.noiseHandling);
        var9_9 = 0.0;
        for (var11_10 = 0; var11_10 < var5_5.length; ++var11_10) {
            if (var5_5[var11_10] == null && this.noiseHandling != NoiseHandling.TREAT_NOISE_AS_SINGLETONS) continue;
            for (var12_12 = var11_10 + 1; var12_12 < var5_5.length; ++var12_12) {
                if (var5_5[var12_12] == null && this.noiseHandling != NoiseHandling.TREAT_NOISE_AS_SINGLETONS) continue;
                if (var5_5[var11_10] == null && var5_5[var12_12] == null) {
                    var13_13 = var4_4.get(var11_10).getIDs().iter();
                    while (var13_13.valid()) {
                        var14_18 = var4_4.get(var12_12).getIDs().iter();
                        while (var14_18.valid()) {
                            var15_21 = this.distanceFunction.distance(var2_2.get(var13_13), var2_2.get(var14_18));
                            var9_9 = var15_21 > var9_9 ? var15_21 : var9_9;
                            var14_18.advance();
                        }
                        var13_13.advance();
                    }
                    continue;
                }
                if (var5_5[var11_10] == null) {
                    var13_14 = var4_4.get(var11_10).getIDs().iter();
                    while (var13_14.valid()) {
                        var14_19 = this.distanceFunction.distance(var2_2.get(var13_14), var5_5[var12_12]);
                        var9_9 = var14_19 > var9_9 ? var14_19 : var9_9;
                        var13_14.advance();
                    }
                    continue;
                }
                if (var5_5[var12_12] == null) {
                    var13_15 = var4_4.get(var12_12).getIDs().iter();
                    while (var13_15.valid()) {
                        var14_20 = this.distanceFunction.distance(var5_5[var11_10], var2_2.get(var13_15));
                        var9_9 = var14_20 > var9_9 ? var14_20 : var9_9;
                        var13_15.advance();
                    }
                    continue;
                }
                var13_16 = this.distanceFunction.distance(var5_5[var11_10], var5_5[var12_12]);
                var9_9 = var13_16 > var9_9 ? var13_16 : var9_9;
            }
        }
        var11_11 = 0.0;
        var13_17 = 0.0;
        var15_22 = var4_4.iterator();
        var16_23 = 0;
        while (var15_22.hasNext()) {
            var17_25 = var15_22.next();
            if (var17_25.size() > 1 && !var17_25.isNoise()) ** GOTO lbl-1000
            switch (1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[this.noiseHandling.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    var18_26 = var17_25.getIDs().iter();
                    while (var18_26.valid()) {
                        var13_17 += SquaredEuclideanDistanceFunction.STATIC.distance(var8_8, var2_2.get((DBIDRef)var18_26));
                        var18_26.advance();
                    }
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    var18_26 = var17_25.getIDs().iter();
                    while (var18_26.valid()) {
                        var19_27 = var2_2.get((DBIDRef)var18_26);
                        var11_11 += this.distanceFunction.distance(var5_5[var16_23], (NumberVector)var19_27);
                        var13_17 += this.distanceFunction.distance(var8_8, (NumberVector)var19_27);
                        var18_26.advance();
                    }
                    break block0;
                }
            }
            ++var16_23;
        }
        var16_24 = Math.pow(1.0 / (double)var5_5.length * (var13_17 / var11_11) * var9_9, 2.0);
        if (EvaluatePBMIndex.LOG.isStatistics()) {
            EvaluatePBMIndex.LOG.statistics(new StringStatistic(this.key + ".pbm.noise-handling", this.noiseHandling.toString()));
            if (var6_6 > 0) {
                EvaluatePBMIndex.LOG.statistics(new LongStatistic(this.key + ".pbm.ignored", var6_6));
            }
            EvaluatePBMIndex.LOG.statistics(new DoubleStatistic(this.key + ".pbm", var16_24));
        }
        var18_26 = EvaluationResult.findOrCreate(var1_1.getHierarchy(), var3_3, "Internal Clustering Evaluation", "internal evaluation");
        var19_27 = var18_26.findOrCreateGroup("Distance-based Evaluation");
        var19_27.addMeasure("PBM-Index", var16_24, 0.0, Infinity, 0.0, false);
        var1_1.getHierarchy().resultChanged((Result)var18_26);
        return var16_24;
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        List<Clustering<? extends Model>> list = ResultUtil.getClusteringResults(result);
        if (list.size() < 1) {
            return;
        }
        Database database = ResultUtil.findDatabase(resultHierarchy);
        Relation relation = database.getRelation(this.distanceFunction.getInputTypeRestriction(), new Object[0]);
        for (Clustering<? extends Model> clustering : list) {
            this.evaluateClustering(database, relation, clustering);
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling;

        static {
            $SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling = new int[NoiseHandling.values().length];
            try {
                1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[NoiseHandling.IGNORE_NOISE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[NoiseHandling.TREAT_NOISE_AS_SINGLETONS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$de$lmu$ifi$dbs$elki$evaluation$clustering$internal$NoiseHandling[NoiseHandling.MERGE_NOISE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("pbm.distance", "Distance function to use for computing PBM.");
        public static final OptionID NOISE_ID = new OptionID("pbm.noisehandling", "Control how noise should be treated.");
        private NumberVectorDistanceFunction<?> distance;
        private NoiseHandling noiseHandling;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            EnumParameter<NoiseHandling> enumParameter;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(DISTANCE_ID, (Class<?>)NumberVectorDistanceFunction.class, EuclideanDistanceFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.distance = (NumberVectorDistanceFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(enumParameter = new EnumParameter<NoiseHandling>(NOISE_ID, NoiseHandling.class, NoiseHandling.TREAT_NOISE_AS_SINGLETONS))) {
                this.noiseHandling = (NoiseHandling)((Object)enumParameter.getValue());
            }
        }

        @Override
        protected EvaluatePBMIndex makeInstance() {
            return new EvaluatePBMIndex(this.distance, this.noiseHandling);
        }
    }
}

