/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.lsh.hashfamilies;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.index.lsh.hashfamilies.LocalitySensitiveHashFunctionFamily;
import de.lmu.ifi.dbs.elki.index.lsh.hashfunctions.LocalitySensitiveHashFunction;
import de.lmu.ifi.dbs.elki.index.lsh.hashfunctions.MultipleProjectionsLocalitySensitiveHashFunction;
import de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.RandomProjectionFamily;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.ArrayList;
import java.util.Random;

public abstract class AbstractProjectedHashFunctionFamily
implements LocalitySensitiveHashFunctionFamily<NumberVector> {
    protected RandomFactory random;
    protected RandomProjectionFamily proj;
    protected double width;
    protected int k;

    public AbstractProjectedHashFunctionFamily(RandomFactory randomFactory, RandomProjectionFamily randomProjectionFamily, double d, int n) {
        this.random = randomFactory;
        this.proj = randomProjectionFamily;
        this.width = d;
        this.k = n;
    }

    @Override
    public ArrayList<? extends LocalitySensitiveHashFunction<? super NumberVector>> generateHashFunctions(Relation<? extends NumberVector> relation, int n) {
        int n2 = RelationUtil.dimensionality(relation);
        ArrayList<MultipleProjectionsLocalitySensitiveHashFunction> arrayList = new ArrayList<MultipleProjectionsLocalitySensitiveHashFunction>(n);
        Random random = this.random.getSingleThreadedRandom();
        for (int i = 0; i < n; ++i) {
            RandomProjectionFamily.Projection projection = this.proj.generateProjection(n2, this.k);
            arrayList.add(new MultipleProjectionsLocalitySensitiveHashFunction(projection, this.width, random));
        }
        return arrayList;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID RANDOM_ID = new OptionID("lsh.projection.random", "Random seed for generating the projections.");
        public static final OptionID WIDTH_ID = new OptionID("lsh.projection.width", "Bin width for random projections.");
        public static final OptionID NUMPROJ_ID = new OptionID("lsh.projection.projections", "Number of projections to use for each hash function.");
        RandomFactory random;
        double width;
        int k;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            RandomParameter randomParameter = new RandomParameter(RANDOM_ID, RandomFactory.DEFAULT);
            if (parameterization.grab(randomParameter)) {
                this.random = (RandomFactory)randomParameter.getValue();
            }
            DoubleParameter doubleParameter = new DoubleParameter(WIDTH_ID);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.width = doubleParameter.doubleValue();
            }
            IntParameter intParameter = new IntParameter(NUMPROJ_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = intParameter.intValue();
            }
        }
    }
}

