/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.lsh.hashfunctions;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.index.lsh.hashfunctions.LocalitySensitiveHashFunction;
import de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.RandomProjectionFamily;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Random;

@Reference(authors="M. Datar and N. Immorlica and P. Indyk and V. S. Mirrokni", title="Locality-sensitive hashing scheme based on p-stable distributions", booktitle="Proc. 20th annual symposium on Computational geometry", url="http://dx.doi.org/10.1145/997817.997857")
public class MultipleProjectionsLocalitySensitiveHashFunction
implements LocalitySensitiveHashFunction<NumberVector> {
    RandomProjectionFamily.Projection projection;
    double[] shift;
    double iwidth;
    int[] randoms1;
    private static final long MASK32 = 0xFFFFFFFFL;

    public MultipleProjectionsLocalitySensitiveHashFunction(RandomProjectionFamily.Projection projection, double d, Random random) {
        this.projection = projection;
        this.iwidth = 1.0 / d;
        int n = projection.getOutputDimensionality();
        this.shift = new double[n];
        this.randoms1 = new int[n];
        for (int i = 0; i < n; ++i) {
            this.shift[i] = random.nextDouble() * d;
            this.randoms1[i] = (random.nextInt(0x10000D) << 16) + random.nextInt(1048573) + 1;
        }
    }

    @Override
    public int hashObject(NumberVector numberVector) {
        double[] dArray = this.projection.project(numberVector);
        long l = 0L;
        for (int i = 0; i < this.shift.length; ++i) {
            int n = (int)Math.floor((dArray[i] + this.shift[i]) * this.iwidth);
            l += ((long)this.randoms1[i] & 0xFFFFFFFFL) * (long)n;
        }
        return MultipleProjectionsLocalitySensitiveHashFunction.fastModPrime(l);
    }

    @Override
    public int hashObject(NumberVector numberVector, double[] dArray) {
        this.projection.project(numberVector, dArray);
        long l = 0L;
        for (int i = 0; i < this.shift.length; ++i) {
            int n = (int)Math.floor((dArray[i] + this.shift[i]) * this.iwidth);
            l += ((long)this.randoms1[i] & 0xFFFFFFFFL) * (long)n;
        }
        return MultipleProjectionsLocalitySensitiveHashFunction.fastModPrime(l);
    }

    public static int fastModPrime(long l) {
        int n = (int)(l >>> 32);
        int n2 = (int)l + (n << 2 + n);
        if (n2 < 0 && n2 > -5) {
            n2 += 5;
        }
        return n2;
    }

    @Override
    public int getNumberOfProjections() {
        return this.projection.getOutputDimensionality();
    }
}

