/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mktab;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RKNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.MkTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mktab.MkTabEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mktab.MkTabLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mktab.MkTabTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mktab.MkTabTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query.MTreeQueryUtil;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query.MkTreeRKNNQuery;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import java.util.ArrayList;

public class MkTabTreeIndex<O>
extends MkTabTree<O>
implements RangeIndex<O>,
KNNIndex<O>,
RKNNIndex<O> {
    private Relation<O> relation;

    public MkTabTreeIndex(Relation<O> relation, PageFile<MkTabTreeNode<O>> pageFile, MkTreeSettings<O, MkTabTreeNode<O>, MkTabEntry> mkTreeSettings) {
        super(relation, pageFile, mkTreeSettings);
        this.relation = relation;
    }

    protected MkTabEntry createNewLeafEntry(DBID dBID, O o, double d) {
        return new MkTabLeafEntry(dBID, d, this.knnDistances(o));
    }

    private double[] knnDistances(O o) {
        KNNList kNNList = this.knnq.getKNNForObject(o, this.getKmax() - 1);
        double[] dArray = new double[this.getKmax()];
        DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
        for (int i = 0; doubleDBIDListIter.valid() && i < this.getKmax(); ++i) {
            dArray[i] = doubleDBIDListIter.doubleValue();
            doubleDBIDListIter.advance();
        }
        return dArray;
    }

    @Override
    public void initialize() {
        super.initialize();
        ArrayList<MkTabEntry> arrayList = new ArrayList<MkTabEntry>(this.relation.size());
        DBIDIter dBIDIter = this.relation.iterDBIDs();
        while (dBIDIter.valid()) {
            DBID dBID = DBIDUtil.deref(dBIDIter);
            O o = this.relation.get(dBID);
            arrayList.add(this.createNewLeafEntry(dBID, o, Double.NaN));
            dBIDIter.advance();
        }
        this.insertAll(arrayList);
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            this.getLogger().debug("Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        return MTreeQueryUtil.getKNNQuery(this, distanceQuery, objectArray);
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            this.getLogger().debug("Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        return MTreeQueryUtil.getRangeQuery(this, distanceQuery, new Object[0]);
    }

    @Override
    public RKNNQuery<O> getRKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            this.getLogger().debug("Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        return new MkTreeRKNNQuery<O>(this, distanceQuery);
    }

    @Override
    public String getLongName() {
        return "MkTab-Tree";
    }

    @Override
    public String getShortName() {
        return "mktabtree";
    }
}

