/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.flat;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.index.tree.Entry;
import de.lmu.ifi.dbs.elki.index.tree.TreeIndexHeader;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.flat.FlatRStarTreeNode;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import java.util.List;

public abstract class FlatRStarTree
extends AbstractRStarTree<FlatRStarTreeNode, SpatialEntry, AbstractRTreeSettings> {
    private static final Logging LOG = Logging.getLogger(FlatRStarTree.class);
    private FlatRStarTreeNode root;

    public FlatRStarTree(PageFile<FlatRStarTreeNode> pageFile, AbstractRTreeSettings abstractRTreeSettings) {
        super(pageFile, abstractRTreeSettings);
    }

    @Override
    public void initializeFromFile(TreeIndexHeader treeIndexHeader, PageFile<FlatRStarTreeNode> pageFile) {
        int n;
        super.initializeFromFile(treeIndexHeader, pageFile);
        this.dirCapacity = n = pageFile.getNextPageID();
        this.root = this.createNewDirectoryNode();
        for (int i = 1; i < n; ++i) {
            FlatRStarTreeNode flatRStarTreeNode = (FlatRStarTreeNode)this.getNode(i);
            this.root.addDirectoryEntry(this.createNewDirectoryEntry(flatRStarTreeNode));
        }
        if (LOG.isDebugging()) {
            LOG.debugFine("root: " + this.root + " with " + n + " leafNodes.");
        }
    }

    @Override
    public FlatRStarTreeNode getRoot() {
        return this.root;
    }

    @Override
    protected int computeHeight() {
        return 2;
    }

    @Override
    protected void bulkLoad(List<SpatialEntry> list) {
        if (!this.initialized) {
            this.initialize((Entry)list.get(0));
        }
        this.getFile().setNextPageID(this.getRootID() + 1);
        List<SpatialEntry> list2 = this.createBulkLeafNodes(list);
        int n = list2.size();
        if (LOG.isDebugging()) {
            LOG.debugFine("  numLeafNodes = " + n);
        }
        this.root = this.createNewDirectoryNode();
        this.root.setPageID(this.getRootID());
        for (SpatialEntry spatialEntry : list2) {
            this.root.addDirectoryEntry(spatialEntry);
        }
        ++n;
        this.setHeight(2);
        if (LOG.isDebugging()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("  root = ").append(this.getRoot());
            stringBuilder.append("\n  numNodes = ").append(n);
            stringBuilder.append("\n  height = ").append(this.getHeight());
            LOG.debugFine(stringBuilder.toString() + "\n");
        }
        this.doExtraIntegrityChecks();
    }

    @Override
    protected void createEmptyRoot(SpatialEntry spatialEntry) {
        this.root = this.createNewDirectoryNode();
        this.root.setPageID(this.getRootID());
        this.getFile().setNextPageID(this.getRootID() + 1);
        FlatRStarTreeNode flatRStarTreeNode = this.createNewLeafNode();
        this.writeNode(flatRStarTreeNode);
        ModifiableHyperBoundingBox modifiableHyperBoundingBox = new ModifiableHyperBoundingBox(new double[spatialEntry.getDimensionality()], new double[spatialEntry.getDimensionality()]);
        this.root.addDirectoryEntry(new SpatialDirectoryEntry(flatRStarTreeNode.getPageID(), modifiableHyperBoundingBox));
        this.setHeight(2);
    }

    @Override
    protected boolean hasOverflow(FlatRStarTreeNode flatRStarTreeNode) {
        if (flatRStarTreeNode.isLeaf()) {
            return flatRStarTreeNode.getNumEntries() == this.leafCapacity;
        }
        if (flatRStarTreeNode.getNumEntries() == flatRStarTreeNode.getCapacity()) {
            flatRStarTreeNode.increaseEntries();
        }
        return false;
    }

    @Override
    protected boolean hasUnderflow(FlatRStarTreeNode flatRStarTreeNode) {
        if (flatRStarTreeNode.isLeaf()) {
            return flatRStarTreeNode.getNumEntries() < this.leafMinimum;
        }
        return false;
    }

    @Override
    protected FlatRStarTreeNode createNewLeafNode() {
        return new FlatRStarTreeNode(this.leafCapacity, true);
    }

    @Override
    protected FlatRStarTreeNode createNewDirectoryNode() {
        return new FlatRStarTreeNode(this.dirCapacity, false);
    }

    @Override
    protected SpatialEntry createNewDirectoryEntry(FlatRStarTreeNode flatRStarTreeNode) {
        return new SpatialDirectoryEntry(flatRStarTreeNode.getPageID(), flatRStarTreeNode.computeMBR());
    }

    @Override
    protected SpatialEntry createRootEntry() {
        return new SpatialDirectoryEntry(0, null);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

